/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.SystemTopicInner;
import java.io.IOException;
import java.util.List;

public final class SystemTopicsListResult
implements JsonSerializable<SystemTopicsListResult> {
    private List<SystemTopicInner> value;
    private String nextLink;

    public List<SystemTopicInner> value() {
        return this.value;
    }

    public SystemTopicsListResult withValue(List<SystemTopicInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public SystemTopicsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SystemTopicsListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SystemTopicsListResult)jsonReader.readObject(reader -> {
            SystemTopicsListResult deserializedSystemTopicsListResult = new SystemTopicsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSystemTopicsListResult.value = value = reader.readArray(reader1 -> SystemTopicInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSystemTopicsListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSystemTopicsListResult;
        });
    }
}

