/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import java.io.IOException;
import java.util.Map;

public final class SystemTopicUpdateParameters
implements JsonSerializable<SystemTopicUpdateParameters> {
    private Map<String, String> tags;
    private IdentityInfo identity;

    public Map<String, String> tags() {
        return this.tags;
    }

    public SystemTopicUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public IdentityInfo identity() {
        return this.identity;
    }

    public SystemTopicUpdateParameters withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static SystemTopicUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SystemTopicUpdateParameters)jsonReader.readObject(reader -> {
            SystemTopicUpdateParameters deserializedSystemTopicUpdateParameters = new SystemTopicUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSystemTopicUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedSystemTopicUpdateParameters.identity = IdentityInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSystemTopicUpdateParameters;
        });
    }
}

