/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.StorageQueueEventSubscriptionDestinationProperties;
import com.azure.resourcemanager.eventgrid.models.EndpointType;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import java.io.IOException;

public final class StorageQueueEventSubscriptionDestination
extends EventSubscriptionDestination {
    private EndpointType endpointType = EndpointType.STORAGE_QUEUE;
    private StorageQueueEventSubscriptionDestinationProperties innerProperties;

    @Override
    public EndpointType endpointType() {
        return this.endpointType;
    }

    StorageQueueEventSubscriptionDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    public StorageQueueEventSubscriptionDestination withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageQueueEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    public String queueName() {
        return this.innerProperties() == null ? null : this.innerProperties().queueName();
    }

    public StorageQueueEventSubscriptionDestination withQueueName(String queueName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageQueueEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withQueueName(queueName);
        return this;
    }

    public Long queueMessageTimeToLiveInSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().queueMessageTimeToLiveInSeconds();
    }

    public StorageQueueEventSubscriptionDestination withQueueMessageTimeToLiveInSeconds(Long queueMessageTimeToLiveInSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageQueueEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withQueueMessageTimeToLiveInSeconds(queueMessageTimeToLiveInSeconds);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static StorageQueueEventSubscriptionDestination fromJson(JsonReader jsonReader) throws IOException {
        return (StorageQueueEventSubscriptionDestination)jsonReader.readObject(reader -> {
            StorageQueueEventSubscriptionDestination deserializedStorageQueueEventSubscriptionDestination = new StorageQueueEventSubscriptionDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointType".equals(fieldName)) {
                    deserializedStorageQueueEventSubscriptionDestination.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageQueueEventSubscriptionDestination.innerProperties = StorageQueueEventSubscriptionDestinationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageQueueEventSubscriptionDestination;
        });
    }
}

