/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.StaticRoutingEnrichment;
import com.azure.resourcemanager.eventgrid.models.StaticRoutingEnrichmentType;
import java.io.IOException;

public final class StaticStringRoutingEnrichment
extends StaticRoutingEnrichment {
    private StaticRoutingEnrichmentType valueType = StaticRoutingEnrichmentType.STRING;
    private String value;

    @Override
    public StaticRoutingEnrichmentType valueType() {
        return this.valueType;
    }

    public String value() {
        return this.value;
    }

    public StaticStringRoutingEnrichment withValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public StaticStringRoutingEnrichment withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("valueType", this.valueType == null ? null : this.valueType.toString());
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static StaticStringRoutingEnrichment fromJson(JsonReader jsonReader) throws IOException {
        return (StaticStringRoutingEnrichment)jsonReader.readObject(reader -> {
            StaticStringRoutingEnrichment deserializedStaticStringRoutingEnrichment = new StaticStringRoutingEnrichment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedStaticStringRoutingEnrichment.withKey(reader.getString());
                    continue;
                }
                if ("valueType".equals(fieldName)) {
                    deserializedStaticStringRoutingEnrichment.valueType = StaticRoutingEnrichmentType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedStaticStringRoutingEnrichment.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStaticStringRoutingEnrichment;
        });
    }
}

