/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DynamicRoutingEnrichment;
import com.azure.resourcemanager.eventgrid.models.StaticRoutingEnrichment;
import java.io.IOException;
import java.util.List;

public final class RoutingEnrichments
implements JsonSerializable<RoutingEnrichments> {
    private List<StaticRoutingEnrichment> staticProperty;
    private List<DynamicRoutingEnrichment> dynamic;

    public List<StaticRoutingEnrichment> staticProperty() {
        return this.staticProperty;
    }

    public RoutingEnrichments withStaticProperty(List<StaticRoutingEnrichment> staticProperty) {
        this.staticProperty = staticProperty;
        return this;
    }

    public List<DynamicRoutingEnrichment> dynamic() {
        return this.dynamic;
    }

    public RoutingEnrichments withDynamic(List<DynamicRoutingEnrichment> dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public void validate() {
        if (this.staticProperty() != null) {
            this.staticProperty().forEach(e -> e.validate());
        }
        if (this.dynamic() != null) {
            this.dynamic().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("static", this.staticProperty, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dynamic", this.dynamic, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RoutingEnrichments fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingEnrichments)jsonReader.readObject(reader -> {
            RoutingEnrichments deserializedRoutingEnrichments = new RoutingEnrichments();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("static".equals(fieldName)) {
                    List staticProperty;
                    deserializedRoutingEnrichments.staticProperty = staticProperty = reader.readArray(reader1 -> StaticRoutingEnrichment.fromJson(reader1));
                    continue;
                }
                if ("dynamic".equals(fieldName)) {
                    List dynamic;
                    deserializedRoutingEnrichments.dynamic = dynamic = reader.readArray(reader1 -> DynamicRoutingEnrichment.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingEnrichments;
        });
    }
}

