/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RetryPolicy
implements JsonSerializable<RetryPolicy> {
    private Integer maxDeliveryAttempts;
    private Integer eventTimeToLiveInMinutes;

    public Integer maxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    public RetryPolicy withMaxDeliveryAttempts(Integer maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        return this;
    }

    public Integer eventTimeToLiveInMinutes() {
        return this.eventTimeToLiveInMinutes;
    }

    public RetryPolicy withEventTimeToLiveInMinutes(Integer eventTimeToLiveInMinutes) {
        this.eventTimeToLiveInMinutes = eventTimeToLiveInMinutes;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxDeliveryAttempts", (Number)this.maxDeliveryAttempts);
        jsonWriter.writeNumberField("eventTimeToLiveInMinutes", (Number)this.eventTimeToLiveInMinutes);
        return jsonWriter.writeEndObject();
    }

    public static RetryPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (RetryPolicy)jsonReader.readObject(reader -> {
            RetryPolicy deserializedRetryPolicy = new RetryPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxDeliveryAttempts".equals(fieldName)) {
                    deserializedRetryPolicy.maxDeliveryAttempts = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("eventTimeToLiveInMinutes".equals(fieldName)) {
                    deserializedRetryPolicy.eventTimeToLiveInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRetryPolicy;
        });
    }
}

