/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterAssociationAccessMode;
import java.io.IOException;

public final class ResourceAssociation
implements JsonSerializable<ResourceAssociation> {
    private String name;
    private NetworkSecurityPerimeterAssociationAccessMode accessMode;

    public String name() {
        return this.name;
    }

    public ResourceAssociation withName(String name) {
        this.name = name;
        return this;
    }

    public NetworkSecurityPerimeterAssociationAccessMode accessMode() {
        return this.accessMode;
    }

    public ResourceAssociation withAccessMode(NetworkSecurityPerimeterAssociationAccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceAssociation fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceAssociation)jsonReader.readObject(reader -> {
            ResourceAssociation deserializedResourceAssociation = new ResourceAssociation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedResourceAssociation.name = reader.getString();
                    continue;
                }
                if ("accessMode".equals(fieldName)) {
                    deserializedResourceAssociation.accessMode = NetworkSecurityPerimeterAssociationAccessMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceAssociation;
        });
    }
}

