/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeadLetterWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.DeliveryWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import java.io.IOException;

public final class PushInfo
implements JsonSerializable<PushInfo> {
    private Integer maxDeliveryCount;
    private String eventTimeToLive;
    private DeadLetterWithResourceIdentity deadLetterDestinationWithResourceIdentity;
    private DeliveryWithResourceIdentity deliveryWithResourceIdentity;
    private EventSubscriptionDestination destination;

    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public PushInfo withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public String eventTimeToLive() {
        return this.eventTimeToLive;
    }

    public PushInfo withEventTimeToLive(String eventTimeToLive) {
        this.eventTimeToLive = eventTimeToLive;
        return this;
    }

    public DeadLetterWithResourceIdentity deadLetterDestinationWithResourceIdentity() {
        return this.deadLetterDestinationWithResourceIdentity;
    }

    public PushInfo withDeadLetterDestinationWithResourceIdentity(DeadLetterWithResourceIdentity deadLetterDestinationWithResourceIdentity) {
        this.deadLetterDestinationWithResourceIdentity = deadLetterDestinationWithResourceIdentity;
        return this;
    }

    public DeliveryWithResourceIdentity deliveryWithResourceIdentity() {
        return this.deliveryWithResourceIdentity;
    }

    public PushInfo withDeliveryWithResourceIdentity(DeliveryWithResourceIdentity deliveryWithResourceIdentity) {
        this.deliveryWithResourceIdentity = deliveryWithResourceIdentity;
        return this;
    }

    public EventSubscriptionDestination destination() {
        return this.destination;
    }

    public PushInfo withDestination(EventSubscriptionDestination destination) {
        this.destination = destination;
        return this;
    }

    public void validate() {
        if (this.deadLetterDestinationWithResourceIdentity() != null) {
            this.deadLetterDestinationWithResourceIdentity().validate();
        }
        if (this.deliveryWithResourceIdentity() != null) {
            this.deliveryWithResourceIdentity().validate();
        }
        if (this.destination() != null) {
            this.destination().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxDeliveryCount", (Number)this.maxDeliveryCount);
        jsonWriter.writeStringField("eventTimeToLive", this.eventTimeToLive);
        jsonWriter.writeJsonField("deadLetterDestinationWithResourceIdentity", (JsonSerializable)this.deadLetterDestinationWithResourceIdentity);
        jsonWriter.writeJsonField("deliveryWithResourceIdentity", (JsonSerializable)this.deliveryWithResourceIdentity);
        jsonWriter.writeJsonField("destination", (JsonSerializable)this.destination);
        return jsonWriter.writeEndObject();
    }

    public static PushInfo fromJson(JsonReader jsonReader) throws IOException {
        return (PushInfo)jsonReader.readObject(reader -> {
            PushInfo deserializedPushInfo = new PushInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxDeliveryCount".equals(fieldName)) {
                    deserializedPushInfo.maxDeliveryCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("eventTimeToLive".equals(fieldName)) {
                    deserializedPushInfo.eventTimeToLive = reader.getString();
                    continue;
                }
                if ("deadLetterDestinationWithResourceIdentity".equals(fieldName)) {
                    deserializedPushInfo.deadLetterDestinationWithResourceIdentity = DeadLetterWithResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("deliveryWithResourceIdentity".equals(fieldName)) {
                    deserializedPushInfo.deliveryWithResourceIdentity = DeliveryWithResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedPushInfo.destination = EventSubscriptionDestination.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPushInfo;
        });
    }
}

