/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterProfileAccessRule;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterConfigurationProfile
implements JsonSerializable<NetworkSecurityPerimeterConfigurationProfile> {
    private String name;
    private String accessRulesVersion;
    private List<NetworkSecurityPerimeterProfileAccessRule> accessRules;
    private String diagnosticSettingsVersion;
    private List<String> enabledLogCategories;

    public String name() {
        return this.name;
    }

    public NetworkSecurityPerimeterConfigurationProfile withName(String name) {
        this.name = name;
        return this;
    }

    public String accessRulesVersion() {
        return this.accessRulesVersion;
    }

    public NetworkSecurityPerimeterConfigurationProfile withAccessRulesVersion(String accessRulesVersion) {
        this.accessRulesVersion = accessRulesVersion;
        return this;
    }

    public List<NetworkSecurityPerimeterProfileAccessRule> accessRules() {
        return this.accessRules;
    }

    public NetworkSecurityPerimeterConfigurationProfile withAccessRules(List<NetworkSecurityPerimeterProfileAccessRule> accessRules) {
        this.accessRules = accessRules;
        return this;
    }

    public String diagnosticSettingsVersion() {
        return this.diagnosticSettingsVersion;
    }

    public NetworkSecurityPerimeterConfigurationProfile withDiagnosticSettingsVersion(String diagnosticSettingsVersion) {
        this.diagnosticSettingsVersion = diagnosticSettingsVersion;
        return this;
    }

    public List<String> enabledLogCategories() {
        return this.enabledLogCategories;
    }

    public NetworkSecurityPerimeterConfigurationProfile withEnabledLogCategories(List<String> enabledLogCategories) {
        this.enabledLogCategories = enabledLogCategories;
        return this;
    }

    public void validate() {
        if (this.accessRules() != null) {
            this.accessRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("accessRulesVersion", this.accessRulesVersion);
        jsonWriter.writeArrayField("accessRules", this.accessRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("diagnosticSettingsVersion", this.diagnosticSettingsVersion);
        jsonWriter.writeArrayField("enabledLogCategories", this.enabledLogCategories, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterConfigurationProfile fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterConfigurationProfile)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationProfile deserializedNetworkSecurityPerimeterConfigurationProfile = new NetworkSecurityPerimeterConfigurationProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProfile.name = reader.getString();
                    continue;
                }
                if ("accessRulesVersion".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProfile.accessRulesVersion = reader.getString();
                    continue;
                }
                if ("accessRules".equals(fieldName)) {
                    List accessRules;
                    deserializedNetworkSecurityPerimeterConfigurationProfile.accessRules = accessRules = reader.readArray(reader1 -> NetworkSecurityPerimeterProfileAccessRule.fromJson(reader1));
                    continue;
                }
                if ("diagnosticSettingsVersion".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProfile.diagnosticSettingsVersion = reader.getString();
                    continue;
                }
                if ("enabledLogCategories".equals(fieldName)) {
                    List enabledLogCategories;
                    deserializedNetworkSecurityPerimeterConfigurationProfile.enabledLogCategories = enabledLogCategories = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterConfigurationProfile;
        });
    }
}

