/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.CustomJwtAuthenticationManagedIdentity;
import java.io.IOException;

public final class IssuerCertificateInfo
implements JsonSerializable<IssuerCertificateInfo> {
    private String certificateUrl;
    private CustomJwtAuthenticationManagedIdentity identity;
    private static final ClientLogger LOGGER = new ClientLogger(IssuerCertificateInfo.class);

    public String certificateUrl() {
        return this.certificateUrl;
    }

    public IssuerCertificateInfo withCertificateUrl(String certificateUrl) {
        this.certificateUrl = certificateUrl;
        return this;
    }

    public CustomJwtAuthenticationManagedIdentity identity() {
        return this.identity;
    }

    public IssuerCertificateInfo withIdentity(CustomJwtAuthenticationManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.certificateUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property certificateUrl in model IssuerCertificateInfo"));
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("certificateUrl", this.certificateUrl);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static IssuerCertificateInfo fromJson(JsonReader jsonReader) throws IOException {
        return (IssuerCertificateInfo)jsonReader.readObject(reader -> {
            IssuerCertificateInfo deserializedIssuerCertificateInfo = new IssuerCertificateInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("certificateUrl".equals(fieldName)) {
                    deserializedIssuerCertificateInfo.certificateUrl = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedIssuerCertificateInfo.identity = CustomJwtAuthenticationManagedIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIssuerCertificateInfo;
        });
    }
}

