/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.IpActionType;
import java.io.IOException;

public final class InboundIpRule
implements JsonSerializable<InboundIpRule> {
    private String ipMask;
    private IpActionType action;

    public String ipMask() {
        return this.ipMask;
    }

    public InboundIpRule withIpMask(String ipMask) {
        this.ipMask = ipMask;
        return this;
    }

    public IpActionType action() {
        return this.action;
    }

    public InboundIpRule withAction(IpActionType action) {
        this.action = action;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipMask", this.ipMask);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    public static InboundIpRule fromJson(JsonReader jsonReader) throws IOException {
        return (InboundIpRule)jsonReader.readObject(reader -> {
            InboundIpRule deserializedInboundIpRule = new InboundIpRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipMask".equals(fieldName)) {
                    deserializedInboundIpRule.ipMask = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedInboundIpRule.action = IpActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInboundIpRule;
        });
    }
}

