/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class FederatedIdentityCredentialInfo
implements JsonSerializable<FederatedIdentityCredentialInfo> {
    private UUID federatedClientId;
    private static final ClientLogger LOGGER = new ClientLogger(FederatedIdentityCredentialInfo.class);

    public UUID federatedClientId() {
        return this.federatedClientId;
    }

    public FederatedIdentityCredentialInfo withFederatedClientId(UUID federatedClientId) {
        this.federatedClientId = federatedClientId;
        return this;
    }

    public void validate() {
        if (this.federatedClientId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property federatedClientId in model FederatedIdentityCredentialInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("federatedClientId", Objects.toString(this.federatedClientId, null));
        return jsonWriter.writeEndObject();
    }

    public static FederatedIdentityCredentialInfo fromJson(JsonReader jsonReader) throws IOException {
        return (FederatedIdentityCredentialInfo)jsonReader.readObject(reader -> {
            FederatedIdentityCredentialInfo deserializedFederatedIdentityCredentialInfo = new FederatedIdentityCredentialInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("federatedClientId".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInfo.federatedClientId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFederatedIdentityCredentialInfo;
        });
    }
}

