/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EncodedIssuerCertificateInfo
implements JsonSerializable<EncodedIssuerCertificateInfo> {
    private String kid;
    private String encodedCertificate;
    private static final ClientLogger LOGGER = new ClientLogger(EncodedIssuerCertificateInfo.class);

    public String kid() {
        return this.kid;
    }

    public EncodedIssuerCertificateInfo withKid(String kid) {
        this.kid = kid;
        return this;
    }

    public String encodedCertificate() {
        return this.encodedCertificate;
    }

    public EncodedIssuerCertificateInfo withEncodedCertificate(String encodedCertificate) {
        this.encodedCertificate = encodedCertificate;
        return this;
    }

    public void validate() {
        if (this.kid() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property kid in model EncodedIssuerCertificateInfo"));
        }
        if (this.encodedCertificate() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property encodedCertificate in model EncodedIssuerCertificateInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kid", this.kid);
        jsonWriter.writeStringField("encodedCertificate", this.encodedCertificate);
        return jsonWriter.writeEndObject();
    }

    public static EncodedIssuerCertificateInfo fromJson(JsonReader jsonReader) throws IOException {
        return (EncodedIssuerCertificateInfo)jsonReader.readObject(reader -> {
            EncodedIssuerCertificateInfo deserializedEncodedIssuerCertificateInfo = new EncodedIssuerCertificateInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kid".equals(fieldName)) {
                    deserializedEncodedIssuerCertificateInfo.kid = reader.getString();
                    continue;
                }
                if ("encodedCertificate".equals(fieldName)) {
                    deserializedEncodedIssuerCertificateInfo.encodedCertificate = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncodedIssuerCertificateInfo;
        });
    }
}

