/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionIdentity;
import java.io.IOException;

public final class DeliveryWithResourceIdentity
implements JsonSerializable<DeliveryWithResourceIdentity> {
    private EventSubscriptionIdentity identity;
    private EventSubscriptionDestination destination;

    public EventSubscriptionIdentity identity() {
        return this.identity;
    }

    public DeliveryWithResourceIdentity withIdentity(EventSubscriptionIdentity identity) {
        this.identity = identity;
        return this;
    }

    public EventSubscriptionDestination destination() {
        return this.destination;
    }

    public DeliveryWithResourceIdentity withDestination(EventSubscriptionDestination destination) {
        this.destination = destination;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.destination() != null) {
            this.destination().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("destination", (JsonSerializable)this.destination);
        return jsonWriter.writeEndObject();
    }

    public static DeliveryWithResourceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryWithResourceIdentity)jsonReader.readObject(reader -> {
            DeliveryWithResourceIdentity deserializedDeliveryWithResourceIdentity = new DeliveryWithResourceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedDeliveryWithResourceIdentity.identity = EventSubscriptionIdentity.fromJson(reader);
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedDeliveryWithResourceIdentity.destination = EventSubscriptionDestination.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryWithResourceIdentity;
        });
    }
}

