/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.CustomJwtAuthenticationManagedIdentityType;
import java.io.IOException;

public final class CustomJwtAuthenticationManagedIdentity
implements JsonSerializable<CustomJwtAuthenticationManagedIdentity> {
    private CustomJwtAuthenticationManagedIdentityType type;
    private String userAssignedIdentity;
    private static final ClientLogger LOGGER = new ClientLogger(CustomJwtAuthenticationManagedIdentity.class);

    public CustomJwtAuthenticationManagedIdentityType type() {
        return this.type;
    }

    public CustomJwtAuthenticationManagedIdentity withType(CustomJwtAuthenticationManagedIdentityType type) {
        this.type = type;
        return this;
    }

    public String userAssignedIdentity() {
        return this.userAssignedIdentity;
    }

    public CustomJwtAuthenticationManagedIdentity withUserAssignedIdentity(String userAssignedIdentity) {
        this.userAssignedIdentity = userAssignedIdentity;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model CustomJwtAuthenticationManagedIdentity"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("userAssignedIdentity", this.userAssignedIdentity);
        return jsonWriter.writeEndObject();
    }

    public static CustomJwtAuthenticationManagedIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (CustomJwtAuthenticationManagedIdentity)jsonReader.readObject(reader -> {
            CustomJwtAuthenticationManagedIdentity deserializedCustomJwtAuthenticationManagedIdentity = new CustomJwtAuthenticationManagedIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedCustomJwtAuthenticationManagedIdentity.type = CustomJwtAuthenticationManagedIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentity".equals(fieldName)) {
                    deserializedCustomJwtAuthenticationManagedIdentity.userAssignedIdentity = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomJwtAuthenticationManagedIdentity;
        });
    }
}

