/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.ChannelInner;
import com.azure.resourcemanager.eventgrid.models.ChannelProvisioningState;
import com.azure.resourcemanager.eventgrid.models.ChannelType;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFullUrl;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicInfo;
import com.azure.resourcemanager.eventgrid.models.ReadinessState;
import java.time.OffsetDateTime;

public interface Channel {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public ChannelType channelType();

    public PartnerTopicInfo partnerTopicInfo();

    public PartnerDestinationInfo partnerDestinationInfo();

    public String messageForActivation();

    public ChannelProvisioningState provisioningState();

    public ReadinessState readinessState();

    public OffsetDateTime expirationTimeIfNotActivatedUtc();

    public String resourceGroupName();

    public ChannelInner innerModel();

    public Update update();

    public Channel refresh();

    public Channel refresh(Context var1);

    public Response<EventSubscriptionFullUrl> getFullUrlWithResponse(Context var1);

    public EventSubscriptionFullUrl getFullUrl();

    public static interface UpdateStages {

        public static interface WithExpirationTimeIfNotActivatedUtc {
            public Update withExpirationTimeIfNotActivatedUtc(OffsetDateTime var1);
        }

        public static interface WithReadinessState {
            public Update withReadinessState(ReadinessState var1);
        }

        public static interface WithProvisioningState {
            public Update withProvisioningState(ChannelProvisioningState var1);
        }

        public static interface WithMessageForActivation {
            public Update withMessageForActivation(String var1);
        }

        public static interface WithPartnerDestinationInfo {
            public Update withPartnerDestinationInfo(PartnerDestinationInfo var1);
        }

        public static interface WithPartnerTopicInfo {
            public Update withPartnerTopicInfo(PartnerTopicInfo var1);
        }

        public static interface WithChannelType {
            public Update withChannelType(ChannelType var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithChannelType,
    UpdateStages.WithPartnerTopicInfo,
    UpdateStages.WithPartnerDestinationInfo,
    UpdateStages.WithMessageForActivation,
    UpdateStages.WithProvisioningState,
    UpdateStages.WithReadinessState,
    UpdateStages.WithExpirationTimeIfNotActivatedUtc {
        public Channel apply();

        public Channel apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithExpirationTimeIfNotActivatedUtc {
            public WithCreate withExpirationTimeIfNotActivatedUtc(OffsetDateTime var1);
        }

        public static interface WithReadinessState {
            public WithCreate withReadinessState(ReadinessState var1);
        }

        public static interface WithProvisioningState {
            public WithCreate withProvisioningState(ChannelProvisioningState var1);
        }

        public static interface WithMessageForActivation {
            public WithCreate withMessageForActivation(String var1);
        }

        public static interface WithPartnerDestinationInfo {
            public WithCreate withPartnerDestinationInfo(PartnerDestinationInfo var1);
        }

        public static interface WithPartnerTopicInfo {
            public WithCreate withPartnerTopicInfo(PartnerTopicInfo var1);
        }

        public static interface WithChannelType {
            public WithCreate withChannelType(ChannelType var1);
        }

        public static interface WithCreate
        extends WithChannelType,
        WithPartnerTopicInfo,
        WithPartnerDestinationInfo,
        WithMessageForActivation,
        WithProvisioningState,
        WithReadinessState,
        WithExpirationTimeIfNotActivatedUtc {
            public Channel create();

            public Channel create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingPartnerNamespace(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

