/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.Filter;
import com.azure.resourcemanager.eventgrid.models.FilterOperatorType;
import java.io.IOException;

public final class BoolEqualsFilter
extends Filter {
    private FilterOperatorType operatorType = FilterOperatorType.BOOL_EQUALS;
    private Boolean value;

    @Override
    public FilterOperatorType operatorType() {
        return this.operatorType;
    }

    public Boolean value() {
        return this.value;
    }

    public BoolEqualsFilter withValue(Boolean value) {
        this.value = value;
        return this;
    }

    @Override
    public BoolEqualsFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeBooleanField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static BoolEqualsFilter fromJson(JsonReader jsonReader) throws IOException {
        return (BoolEqualsFilter)jsonReader.readObject(reader -> {
            BoolEqualsFilter deserializedBoolEqualsFilter = new BoolEqualsFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedBoolEqualsFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedBoolEqualsFilter.operatorType = FilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedBoolEqualsFilter.value = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBoolEqualsFilter;
        });
    }
}

