/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.TopicEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.DeliveryAttributeListResultInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionFullUrlInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionsListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TopicEventSubscriptionsClientImpl
implements TopicEventSubscriptionsClient {
    private final TopicEventSubscriptionsService service;
    private final EventGridManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(TopicEventSubscriptionsClientImpl.class);

    TopicEventSubscriptionsClientImpl(EventGridManagementClientImpl client) {
        this.service = (TopicEventSubscriptionsService)RestProxy.create(TopicEventSubscriptionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeliveryAttributeListResultInner>> getDeliveryAttributesWithResponseAsync(String resourceGroupName, String topicName, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeliveryAttributes(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeliveryAttributeListResultInner> getDeliveryAttributesAsync(String resourceGroupName, String topicName, String eventSubscriptionName) {
        return this.getDeliveryAttributesWithResponseAsync(resourceGroupName, topicName, eventSubscriptionName).flatMap(res -> Mono.justOrEmpty((Object)((DeliveryAttributeListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeliveryAttributeListResultInner> getDeliveryAttributesWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getDeliveryAttributesSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeliveryAttributeListResultInner getDeliveryAttributes(String resourceGroupName, String topicName, String eventSubscriptionName) {
        return (DeliveryAttributeListResultInner)this.getDeliveryAttributesWithResponse(resourceGroupName, topicName, eventSubscriptionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventSubscriptionInner>> getWithResponseAsync(String resourceGroupName, String topicName, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionInner> getAsync(String resourceGroupName, String topicName, String eventSubscriptionName) {
        return this.getWithResponseAsync(resourceGroupName, topicName, eventSubscriptionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((EventSubscriptionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<EventSubscriptionInner> getWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionInner get(String resourceGroupName, String topicName, String eventSubscriptionName) {
        return (EventSubscriptionInner)((Object)this.getWithResponse(resourceGroupName, topicName, eventSubscriptionName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionInfo is required and cannot be null."));
        }
        eventSubscriptionInfo.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionInfo, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionInfo == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionInfo is required and cannot be null."));
        }
        eventSubscriptionInfo.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionInfo, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionInfo == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionInfo is required and cannot be null."));
        }
        eventSubscriptionInfo.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionInfo, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginCreateOrUpdateAsync(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionInfo);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)EventSubscriptionInner.class), (Type)((Object)EventSubscriptionInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginCreateOrUpdate(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionInfo);
        return this.client.getLroResult(response, (Type)((Object)EventSubscriptionInner.class), (Type)((Object)EventSubscriptionInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginCreateOrUpdate(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionInfo, context);
        return this.client.getLroResult(response, (Type)((Object)EventSubscriptionInner.class), (Type)((Object)EventSubscriptionInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionInner> createOrUpdateAsync(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionInfo).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionInner createOrUpdate(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        return (EventSubscriptionInner)((Object)this.beginCreateOrUpdate(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionInfo).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionInner createOrUpdate(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo, Context context) {
        return (EventSubscriptionInner)((Object)this.beginCreateOrUpdate(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionInfo, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String topicName, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String topicName, String eventSubscriptionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, topicName, eventSubscriptionName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String topicName, String eventSubscriptionName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, topicName, eventSubscriptionName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String topicName, String eventSubscriptionName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, topicName, eventSubscriptionName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String topicName, String eventSubscriptionName) {
        return this.beginDeleteAsync(resourceGroupName, topicName, eventSubscriptionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String topicName, String eventSubscriptionName) {
        this.beginDelete(resourceGroupName, topicName, eventSubscriptionName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String topicName, String eventSubscriptionName, Context context) {
        this.beginDelete(resourceGroupName, topicName, eventSubscriptionName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionUpdateParameters is required and cannot be null."));
        }
        eventSubscriptionUpdateParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionUpdateParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionUpdateParameters is required and cannot be null."));
        }
        eventSubscriptionUpdateParameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionUpdateParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionUpdateParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionUpdateParameters is required and cannot be null."));
        }
        eventSubscriptionUpdateParameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginUpdateAsync(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)EventSubscriptionInner.class), (Type)((Object)EventSubscriptionInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginUpdate(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)EventSubscriptionInner.class), (Type)((Object)EventSubscriptionInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginUpdate(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionUpdateParameters, context);
        return this.client.getLroResult(response, (Type)((Object)EventSubscriptionInner.class), (Type)((Object)EventSubscriptionInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionInner> updateAsync(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionInner update(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        return (EventSubscriptionInner)((Object)this.beginUpdate(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionUpdateParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionInner update(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        return (EventSubscriptionInner)((Object)this.beginUpdate(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionUpdateParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventSubscriptionFullUrlInner>> getFullUrlWithResponseAsync(String resourceGroupName, String topicName, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFullUrl(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionFullUrlInner> getFullUrlAsync(String resourceGroupName, String topicName, String eventSubscriptionName) {
        return this.getFullUrlWithResponseAsync(resourceGroupName, topicName, eventSubscriptionName).flatMap(res -> Mono.justOrEmpty((Object)((EventSubscriptionFullUrlInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<EventSubscriptionFullUrlInner> getFullUrlWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getFullUrlSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, eventSubscriptionName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionFullUrlInner getFullUrl(String resourceGroupName, String topicName, String eventSubscriptionName) {
        return (EventSubscriptionFullUrlInner)this.getFullUrlWithResponse(resourceGroupName, topicName, eventSubscriptionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listSinglePageAsync(String resourceGroupName, String topicName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listAsync(String resourceGroupName, String topicName, String filter, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, topicName, filter, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listAsync(String resourceGroupName, String topicName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, topicName, filter, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<EventSubscriptionInner> listSinglePage(String resourceGroupName, String topicName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<EventSubscriptionsListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), filter, top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<EventSubscriptionInner> listSinglePage(String resourceGroupName, String topicName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<EventSubscriptionsListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), filter, top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> list(String resourceGroupName, String topicName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, topicName, filter, top), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> list(String resourceGroupName, String topicName, String filter, Integer top, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, topicName, filter, top, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<EventSubscriptionInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<EventSubscriptionsListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<EventSubscriptionInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<EventSubscriptionsListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementClientTopicEventSubscriptions")
    public static interface TopicEventSubscriptionsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}/getDeliveryAttributes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeliveryAttributeListResultInner>> getDeliveryAttributes(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}/getDeliveryAttributes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeliveryAttributeListResultInner> getDeliveryAttributesSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<EventSubscriptionInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") EventSubscriptionInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") EventSubscriptionInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") EventSubscriptionUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") EventSubscriptionUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}/getFullUrl")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionFullUrlInner>> getFullUrl(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}/getFullUrl")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<EventSubscriptionFullUrlInner> getFullUrlSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="eventSubscriptionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<EventSubscriptionsListResult> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<EventSubscriptionsListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

