/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.SystemTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.SystemTopicInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.implementation.SystemTopicImpl;
import com.azure.resourcemanager.eventgrid.models.SystemTopic;
import com.azure.resourcemanager.eventgrid.models.SystemTopics;

public final class SystemTopicsImpl
implements SystemTopics {
    private static final ClientLogger LOGGER = new ClientLogger(SystemTopicsImpl.class);
    private final SystemTopicsClient innerClient;
    private final EventGridManager serviceManager;

    public SystemTopicsImpl(SystemTopicsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SystemTopic> getByResourceGroupWithResponse(String resourceGroupName, String systemTopicName, Context context) {
        Response<SystemTopicInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, systemTopicName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SystemTopicImpl((SystemTopicInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SystemTopic getByResourceGroup(String resourceGroupName, String systemTopicName) {
        SystemTopicInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, systemTopicName);
        if (inner != null) {
            return new SystemTopicImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String systemTopicName) {
        this.serviceClient().delete(resourceGroupName, systemTopicName);
    }

    @Override
    public void delete(String resourceGroupName, String systemTopicName, Context context) {
        this.serviceClient().delete(resourceGroupName, systemTopicName, context);
    }

    @Override
    public PagedIterable<SystemTopic> list() {
        PagedIterable<SystemTopicInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SystemTopicImpl((SystemTopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SystemTopic> list(String filter, Integer top, Context context) {
        PagedIterable<SystemTopicInner> inner = this.serviceClient().list(filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SystemTopicImpl((SystemTopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SystemTopic> listByResourceGroup(String resourceGroupName) {
        PagedIterable<SystemTopicInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SystemTopicImpl((SystemTopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SystemTopic> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context) {
        PagedIterable<SystemTopicInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SystemTopicImpl((SystemTopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public SystemTopic getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String systemTopicName = ResourceManagerUtils.getValueFromIdByName(id, "systemTopics");
        if (systemTopicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'systemTopics'.", id)));
        }
        return (SystemTopic)this.getByResourceGroupWithResponse(resourceGroupName, systemTopicName, Context.NONE).getValue();
    }

    @Override
    public Response<SystemTopic> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String systemTopicName = ResourceManagerUtils.getValueFromIdByName(id, "systemTopics");
        if (systemTopicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'systemTopics'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, systemTopicName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String systemTopicName = ResourceManagerUtils.getValueFromIdByName(id, "systemTopics");
        if (systemTopicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'systemTopics'.", id)));
        }
        this.delete(resourceGroupName, systemTopicName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String systemTopicName = ResourceManagerUtils.getValueFromIdByName(id, "systemTopics");
        if (systemTopicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'systemTopics'.", id)));
        }
        this.delete(resourceGroupName, systemTopicName, context);
    }

    private SystemTopicsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public SystemTopicImpl define(String name) {
        return new SystemTopicImpl(name, this.manager());
    }
}

