/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import com.azure.resourcemanager.eventgrid.models.PrivateLinkResourcesListResult;
import reactor.core.publisher.Mono;

public final class PrivateLinkResourcesClientImpl
implements PrivateLinkResourcesClient {
    private final PrivateLinkResourcesService service;
    private final EventGridManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesClientImpl.class);

    PrivateLinkResourcesClientImpl(EventGridManagementClientImpl client) {
        this.service = (PrivateLinkResourcesService)RestProxy.create(PrivateLinkResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourceInner>> getWithResponseAsync(String resourceGroupName, String parentType, String parentName, String privateLinkResourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentType is required and cannot be null."));
        }
        if (parentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentName is required and cannot be null."));
        }
        if (privateLinkResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateLinkResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, parentType, parentName, privateLinkResourceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateLinkResourceInner> getAsync(String resourceGroupName, String parentType, String parentName, String privateLinkResourceName) {
        return this.getWithResponseAsync(resourceGroupName, parentType, parentName, privateLinkResourceName).flatMap(res -> Mono.justOrEmpty((Object)((PrivateLinkResourceInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateLinkResourceInner> getWithResponse(String resourceGroupName, String parentType, String parentName, String privateLinkResourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentType is required and cannot be null."));
        }
        if (parentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentName is required and cannot be null."));
        }
        if (privateLinkResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter privateLinkResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, parentType, parentName, privateLinkResourceName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateLinkResourceInner get(String resourceGroupName, String parentType, String parentName, String privateLinkResourceName) {
        return (PrivateLinkResourceInner)this.getWithResponse(resourceGroupName, parentType, parentName, privateLinkResourceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateLinkResourceInner>> listByResourceSinglePageAsync(String resourceGroupName, String parentType, String parentName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentType is required and cannot be null."));
        }
        if (parentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResource(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, parentType, parentName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourcesListResult)res.getValue()).value(), ((PrivateLinkResourcesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PrivateLinkResourceInner> listByResourceAsync(String resourceGroupName, String parentType, String parentName, String filter, Integer top) {
        return new PagedFlux(() -> this.listByResourceSinglePageAsync(resourceGroupName, parentType, parentName, filter, top), nextLink -> this.listByResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PrivateLinkResourceInner> listByResourceAsync(String resourceGroupName, String parentType, String parentName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByResourceSinglePageAsync(resourceGroupName, parentType, parentName, filter, top), nextLink -> this.listByResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PrivateLinkResourceInner> listByResourceSinglePage(String resourceGroupName, String parentType, String parentName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentType is required and cannot be null."));
        }
        if (parentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PrivateLinkResourcesListResult> res = this.service.listByResourceSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, parentType, parentName, this.client.getApiVersion(), filter, top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourcesListResult)res.getValue()).value(), ((PrivateLinkResourcesListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PrivateLinkResourceInner> listByResourceSinglePage(String resourceGroupName, String parentType, String parentName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentType is required and cannot be null."));
        }
        if (parentName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PrivateLinkResourcesListResult> res = this.service.listByResourceSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, parentType, parentName, this.client.getApiVersion(), filter, top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourcesListResult)res.getValue()).value(), ((PrivateLinkResourcesListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PrivateLinkResourceInner> listByResource(String resourceGroupName, String parentType, String parentName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(() -> this.listByResourceSinglePage(resourceGroupName, parentType, parentName, filter, top), nextLink -> this.listByResourceNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PrivateLinkResourceInner> listByResource(String resourceGroupName, String parentType, String parentName, String filter, Integer top, Context context) {
        return new PagedIterable(() -> this.listByResourceSinglePage(resourceGroupName, parentType, parentName, filter, top, context), nextLink -> this.listByResourceNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateLinkResourceInner>> listByResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourcesListResult)res.getValue()).value(), ((PrivateLinkResourcesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PrivateLinkResourceInner> listByResourceNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PrivateLinkResourcesListResult> res = this.service.listByResourceNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourcesListResult)res.getValue()).value(), ((PrivateLinkResourcesListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PrivateLinkResourceInner> listByResourceNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PrivateLinkResourcesListResult> res = this.service.listByResourceNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourcesListResult)res.getValue()).value(), ((PrivateLinkResourcesListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementClientPrivateLinkResources")
    public static interface PrivateLinkResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{parentType}/{parentName}/privateLinkResources/{privateLinkResourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="parentType") String var4, @PathParam(value="parentName") String var5, @PathParam(value="privateLinkResourceName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{parentType}/{parentName}/privateLinkResources/{privateLinkResourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PrivateLinkResourceInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="parentType") String var4, @PathParam(value="parentName") String var5, @PathParam(value="privateLinkResourceName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{parentType}/{parentName}/privateLinkResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourcesListResult>> listByResource(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="parentType") String var4, @PathParam(value="parentName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$top") Integer var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{parentType}/{parentName}/privateLinkResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PrivateLinkResourcesListResult> listByResourceSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="parentType") String var4, @PathParam(value="parentName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$top") Integer var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourcesListResult>> listByResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PrivateLinkResourcesListResult> listByResourceNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

