/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerDestinationInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.PartnerDestination;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationActivationState;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public final class PartnerDestinationImpl
implements PartnerDestination,
PartnerDestination.Definition,
PartnerDestination.Update {
    private PartnerDestinationInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String partnerDestinationName;
    private PartnerDestinationUpdateParameters updatePartnerDestinationUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public UUID partnerRegistrationImmutableId() {
        return this.innerModel().partnerRegistrationImmutableId();
    }

    @Override
    public String endpointServiceContext() {
        return this.innerModel().endpointServiceContext();
    }

    @Override
    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.innerModel().expirationTimeIfNotActivatedUtc();
    }

    @Override
    public PartnerDestinationProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public PartnerDestinationActivationState activationState() {
        return this.innerModel().activationState();
    }

    @Override
    public String endpointBaseUrl() {
        return this.innerModel().endpointBaseUrl();
    }

    @Override
    public String messageForActivation() {
        return this.innerModel().messageForActivation();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PartnerDestinationInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public PartnerDestinationImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public PartnerDestination create() {
        this.innerObject = this.serviceManager.serviceClient().getPartnerDestinations().createOrUpdate(this.resourceGroupName, this.partnerDestinationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PartnerDestination create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPartnerDestinations().createOrUpdate(this.resourceGroupName, this.partnerDestinationName, this.innerModel(), context);
        return this;
    }

    PartnerDestinationImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new PartnerDestinationInner();
        this.serviceManager = serviceManager;
        this.partnerDestinationName = name;
    }

    @Override
    public PartnerDestinationImpl update() {
        this.updatePartnerDestinationUpdateParameters = new PartnerDestinationUpdateParameters();
        return this;
    }

    @Override
    public PartnerDestination apply() {
        this.innerObject = this.serviceManager.serviceClient().getPartnerDestinations().update(this.resourceGroupName, this.partnerDestinationName, this.updatePartnerDestinationUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public PartnerDestination apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPartnerDestinations().update(this.resourceGroupName, this.partnerDestinationName, this.updatePartnerDestinationUpdateParameters, context);
        return this;
    }

    PartnerDestinationImpl(PartnerDestinationInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.partnerDestinationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "partnerDestinations");
    }

    @Override
    public PartnerDestination refresh() {
        this.innerObject = (PartnerDestinationInner)((Object)this.serviceManager.serviceClient().getPartnerDestinations().getByResourceGroupWithResponse(this.resourceGroupName, this.partnerDestinationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PartnerDestination refresh(Context context) {
        this.innerObject = (PartnerDestinationInner)((Object)this.serviceManager.serviceClient().getPartnerDestinations().getByResourceGroupWithResponse(this.resourceGroupName, this.partnerDestinationName, context).getValue());
        return this;
    }

    @Override
    public Response<PartnerDestination> activateWithResponse(Context context) {
        return this.serviceManager.partnerDestinations().activateWithResponse(this.resourceGroupName, this.partnerDestinationName, context);
    }

    @Override
    public PartnerDestination activate() {
        return this.serviceManager.partnerDestinations().activate(this.resourceGroupName, this.partnerDestinationName);
    }

    @Override
    public PartnerDestinationImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public PartnerDestinationImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public PartnerDestinationImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updatePartnerDestinationUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public PartnerDestinationImpl withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.innerModel().withPartnerRegistrationImmutableId(partnerRegistrationImmutableId);
        return this;
    }

    @Override
    public PartnerDestinationImpl withEndpointServiceContext(String endpointServiceContext) {
        this.innerModel().withEndpointServiceContext(endpointServiceContext);
        return this;
    }

    @Override
    public PartnerDestinationImpl withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        this.innerModel().withExpirationTimeIfNotActivatedUtc(expirationTimeIfNotActivatedUtc);
        return this;
    }

    @Override
    public PartnerDestinationImpl withActivationState(PartnerDestinationActivationState activationState) {
        this.innerModel().withActivationState(activationState);
        return this;
    }

    @Override
    public PartnerDestinationImpl withEndpointBaseUrl(String endpointBaseUrl) {
        this.innerModel().withEndpointBaseUrl(endpointBaseUrl);
        return this;
    }

    @Override
    public PartnerDestinationImpl withMessageForActivation(String messageForActivation) {
        this.innerModel().withMessageForActivation(messageForActivation);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

