/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.NetworkSecurityPerimeterConfigurationsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.NetworkSecurityPerimeterConfigurationInner;
import com.azure.resourcemanager.eventgrid.implementation.NetworkSecurityPerimeterConfigurationImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfiguration;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfigurations;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterResourceType;

public final class NetworkSecurityPerimeterConfigurationsImpl
implements NetworkSecurityPerimeterConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(NetworkSecurityPerimeterConfigurationsImpl.class);
    private final NetworkSecurityPerimeterConfigurationsClient innerClient;
    private final EventGridManager serviceManager;

    public NetworkSecurityPerimeterConfigurationsImpl(NetworkSecurityPerimeterConfigurationsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NetworkSecurityPerimeterConfiguration> getWithResponse(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName, Context context) {
        Response<NetworkSecurityPerimeterConfigurationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NetworkSecurityPerimeterConfigurationImpl((NetworkSecurityPerimeterConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NetworkSecurityPerimeterConfiguration get(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        NetworkSecurityPerimeterConfigurationInner inner = this.serviceClient().get(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName);
        if (inner != null) {
            return new NetworkSecurityPerimeterConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public NetworkSecurityPerimeterConfiguration reconcile(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName) {
        NetworkSecurityPerimeterConfigurationInner inner = this.serviceClient().reconcile(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName);
        if (inner != null) {
            return new NetworkSecurityPerimeterConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public NetworkSecurityPerimeterConfiguration reconcile(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, String perimeterGuid, String associationName, Context context) {
        NetworkSecurityPerimeterConfigurationInner inner = this.serviceClient().reconcile(resourceGroupName, resourceType, resourceName, perimeterGuid, associationName, context);
        if (inner != null) {
            return new NetworkSecurityPerimeterConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<NetworkSecurityPerimeterConfiguration> list(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName) {
        PagedIterable<NetworkSecurityPerimeterConfigurationInner> inner = this.serviceClient().list(resourceGroupName, resourceType, resourceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkSecurityPerimeterConfigurationImpl((NetworkSecurityPerimeterConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NetworkSecurityPerimeterConfiguration> list(String resourceGroupName, NetworkSecurityPerimeterResourceType resourceType, String resourceName, Context context) {
        PagedIterable<NetworkSecurityPerimeterConfigurationInner> inner = this.serviceClient().list(resourceGroupName, resourceType, resourceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NetworkSecurityPerimeterConfigurationImpl((NetworkSecurityPerimeterConfigurationInner)((Object)inner1), this.manager()));
    }

    private NetworkSecurityPerimeterConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }
}

