/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.ChannelsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.ChannelInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionFullUrlInner;
import com.azure.resourcemanager.eventgrid.implementation.ChannelImpl;
import com.azure.resourcemanager.eventgrid.implementation.EventSubscriptionFullUrlImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.Channel;
import com.azure.resourcemanager.eventgrid.models.ChannelUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.Channels;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFullUrl;

public final class ChannelsImpl
implements Channels {
    private static final ClientLogger LOGGER = new ClientLogger(ChannelsImpl.class);
    private final ChannelsClient innerClient;
    private final EventGridManager serviceManager;

    public ChannelsImpl(ChannelsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Channel> getWithResponse(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        Response<ChannelInner> inner = this.serviceClient().getWithResponse(resourceGroupName, partnerNamespaceName, channelName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ChannelImpl((ChannelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Channel get(String resourceGroupName, String partnerNamespaceName, String channelName) {
        ChannelInner inner = this.serviceClient().get(resourceGroupName, partnerNamespaceName, channelName);
        if (inner != null) {
            return new ChannelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String partnerNamespaceName, String channelName) {
        this.serviceClient().delete(resourceGroupName, partnerNamespaceName, channelName);
    }

    @Override
    public void delete(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        this.serviceClient().delete(resourceGroupName, partnerNamespaceName, channelName, context);
    }

    @Override
    public Response<Void> updateWithResponse(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelUpdateParameters channelUpdateParameters, Context context) {
        return this.serviceClient().updateWithResponse(resourceGroupName, partnerNamespaceName, channelName, channelUpdateParameters, context);
    }

    @Override
    public void update(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelUpdateParameters channelUpdateParameters) {
        this.serviceClient().update(resourceGroupName, partnerNamespaceName, channelName, channelUpdateParameters);
    }

    @Override
    public PagedIterable<Channel> listByPartnerNamespace(String resourceGroupName, String partnerNamespaceName) {
        PagedIterable<ChannelInner> inner = this.serviceClient().listByPartnerNamespace(resourceGroupName, partnerNamespaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ChannelImpl((ChannelInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Channel> listByPartnerNamespace(String resourceGroupName, String partnerNamespaceName, String filter, Integer top, Context context) {
        PagedIterable<ChannelInner> inner = this.serviceClient().listByPartnerNamespace(resourceGroupName, partnerNamespaceName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ChannelImpl((ChannelInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<EventSubscriptionFullUrl> getFullUrlWithResponse(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        Response<EventSubscriptionFullUrlInner> inner = this.serviceClient().getFullUrlWithResponse(resourceGroupName, partnerNamespaceName, channelName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new EventSubscriptionFullUrlImpl((EventSubscriptionFullUrlInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public EventSubscriptionFullUrl getFullUrl(String resourceGroupName, String partnerNamespaceName, String channelName) {
        EventSubscriptionFullUrlInner inner = this.serviceClient().getFullUrl(resourceGroupName, partnerNamespaceName, channelName);
        if (inner != null) {
            return new EventSubscriptionFullUrlImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Channel getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerNamespaceName = ResourceManagerUtils.getValueFromIdByName(id, "partnerNamespaces");
        if (partnerNamespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerNamespaces'.", id)));
        }
        String channelName = ResourceManagerUtils.getValueFromIdByName(id, "channels");
        if (channelName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'channels'.", id)));
        }
        return (Channel)this.getWithResponse(resourceGroupName, partnerNamespaceName, channelName, Context.NONE).getValue();
    }

    @Override
    public Response<Channel> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerNamespaceName = ResourceManagerUtils.getValueFromIdByName(id, "partnerNamespaces");
        if (partnerNamespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerNamespaces'.", id)));
        }
        String channelName = ResourceManagerUtils.getValueFromIdByName(id, "channels");
        if (channelName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'channels'.", id)));
        }
        return this.getWithResponse(resourceGroupName, partnerNamespaceName, channelName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerNamespaceName = ResourceManagerUtils.getValueFromIdByName(id, "partnerNamespaces");
        if (partnerNamespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerNamespaces'.", id)));
        }
        String channelName = ResourceManagerUtils.getValueFromIdByName(id, "channels");
        if (channelName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'channels'.", id)));
        }
        this.delete(resourceGroupName, partnerNamespaceName, channelName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerNamespaceName = ResourceManagerUtils.getValueFromIdByName(id, "partnerNamespaces");
        if (partnerNamespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerNamespaces'.", id)));
        }
        String channelName = ResourceManagerUtils.getValueFromIdByName(id, "channels");
        if (channelName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'channels'.", id)));
        }
        this.delete(resourceGroupName, partnerNamespaceName, channelName, context);
    }

    private ChannelsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public ChannelImpl define(String name) {
        return new ChannelImpl(name, this.manager());
    }
}

