/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.CaCertificatesClient;
import com.azure.resourcemanager.eventgrid.fluent.models.CaCertificateInner;
import com.azure.resourcemanager.eventgrid.implementation.CaCertificateImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.CaCertificate;
import com.azure.resourcemanager.eventgrid.models.CaCertificates;

public final class CaCertificatesImpl
implements CaCertificates {
    private static final ClientLogger LOGGER = new ClientLogger(CaCertificatesImpl.class);
    private final CaCertificatesClient innerClient;
    private final EventGridManager serviceManager;

    public CaCertificatesImpl(CaCertificatesClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CaCertificate> getWithResponse(String resourceGroupName, String namespaceName, String caCertificateName, Context context) {
        Response<CaCertificateInner> inner = this.serviceClient().getWithResponse(resourceGroupName, namespaceName, caCertificateName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CaCertificateImpl((CaCertificateInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public CaCertificate get(String resourceGroupName, String namespaceName, String caCertificateName) {
        CaCertificateInner inner = this.serviceClient().get(resourceGroupName, namespaceName, caCertificateName);
        if (inner != null) {
            return new CaCertificateImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String caCertificateName) {
        this.serviceClient().delete(resourceGroupName, namespaceName, caCertificateName);
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String caCertificateName, Context context) {
        this.serviceClient().delete(resourceGroupName, namespaceName, caCertificateName, context);
    }

    @Override
    public PagedIterable<CaCertificate> listByNamespace(String resourceGroupName, String namespaceName) {
        PagedIterable<CaCertificateInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CaCertificateImpl((CaCertificateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CaCertificate> listByNamespace(String resourceGroupName, String namespaceName, String filter, Integer top, Context context) {
        PagedIterable<CaCertificateInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CaCertificateImpl((CaCertificateInner)((Object)inner1), this.manager()));
    }

    @Override
    public CaCertificate getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String caCertificateName = ResourceManagerUtils.getValueFromIdByName(id, "caCertificates");
        if (caCertificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caCertificates'.", id)));
        }
        return (CaCertificate)this.getWithResponse(resourceGroupName, namespaceName, caCertificateName, Context.NONE).getValue();
    }

    @Override
    public Response<CaCertificate> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String caCertificateName = ResourceManagerUtils.getValueFromIdByName(id, "caCertificates");
        if (caCertificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caCertificates'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, caCertificateName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String caCertificateName = ResourceManagerUtils.getValueFromIdByName(id, "caCertificates");
        if (caCertificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caCertificates'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, caCertificateName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String caCertificateName = ResourceManagerUtils.getValueFromIdByName(id, "caCertificates");
        if (caCertificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caCertificates'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, caCertificateName, context);
    }

    private CaCertificatesClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public CaCertificateImpl define(String name) {
        return new CaCertificateImpl(name, this.manager());
    }
}

