/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerClientAuthentication;
import java.io.IOException;

public final class WebhookPartnerDestinationProperties
implements JsonSerializable<WebhookPartnerDestinationProperties> {
    private String endpointUrl;
    private String endpointBaseUrl;
    private PartnerClientAuthentication clientAuthentication;

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public WebhookPartnerDestinationProperties withEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
        return this;
    }

    public String endpointBaseUrl() {
        return this.endpointBaseUrl;
    }

    public WebhookPartnerDestinationProperties withEndpointBaseUrl(String endpointBaseUrl) {
        this.endpointBaseUrl = endpointBaseUrl;
        return this;
    }

    public PartnerClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public WebhookPartnerDestinationProperties withClientAuthentication(PartnerClientAuthentication clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
        return this;
    }

    public void validate() {
        if (this.clientAuthentication() != null) {
            this.clientAuthentication().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointUrl", this.endpointUrl);
        jsonWriter.writeStringField("endpointBaseUrl", this.endpointBaseUrl);
        jsonWriter.writeJsonField("clientAuthentication", (JsonSerializable)this.clientAuthentication);
        return jsonWriter.writeEndObject();
    }

    public static WebhookPartnerDestinationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookPartnerDestinationProperties)jsonReader.readObject(reader -> {
            WebhookPartnerDestinationProperties deserializedWebhookPartnerDestinationProperties = new WebhookPartnerDestinationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointUrl".equals(fieldName)) {
                    deserializedWebhookPartnerDestinationProperties.endpointUrl = reader.getString();
                    continue;
                }
                if ("endpointBaseUrl".equals(fieldName)) {
                    deserializedWebhookPartnerDestinationProperties.endpointBaseUrl = reader.getString();
                    continue;
                }
                if ("clientAuthentication".equals(fieldName)) {
                    deserializedWebhookPartnerDestinationProperties.clientAuthentication = PartnerClientAuthentication.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookPartnerDestinationProperties;
        });
    }
}

