/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.VerifiedPartnerProperties;
import com.azure.resourcemanager.eventgrid.models.PartnerDetails;
import com.azure.resourcemanager.eventgrid.models.VerifiedPartnerProvisioningState;
import java.io.IOException;
import java.util.UUID;

public final class VerifiedPartnerInner
extends ProxyResource {
    private VerifiedPartnerProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private VerifiedPartnerProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public UUID partnerRegistrationImmutableId() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerRegistrationImmutableId();
    }

    public VerifiedPartnerInner withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withPartnerRegistrationImmutableId(partnerRegistrationImmutableId);
        return this;
    }

    public String organizationName() {
        return this.innerProperties() == null ? null : this.innerProperties().organizationName();
    }

    public VerifiedPartnerInner withOrganizationName(String organizationName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withOrganizationName(organizationName);
        return this;
    }

    public String partnerDisplayName() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerDisplayName();
    }

    public VerifiedPartnerInner withPartnerDisplayName(String partnerDisplayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withPartnerDisplayName(partnerDisplayName);
        return this;
    }

    public PartnerDetails partnerTopicDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerTopicDetails();
    }

    public VerifiedPartnerInner withPartnerTopicDetails(PartnerDetails partnerTopicDetails) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withPartnerTopicDetails(partnerTopicDetails);
        return this;
    }

    public PartnerDetails partnerDestinationDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerDestinationDetails();
    }

    public VerifiedPartnerInner withPartnerDestinationDetails(PartnerDetails partnerDestinationDetails) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withPartnerDestinationDetails(partnerDestinationDetails);
        return this;
    }

    public VerifiedPartnerProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public VerifiedPartnerInner withProvisioningState(VerifiedPartnerProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VerifiedPartnerInner fromJson(JsonReader jsonReader) throws IOException {
        return (VerifiedPartnerInner)((Object)jsonReader.readObject(reader -> {
            VerifiedPartnerInner deserializedVerifiedPartnerInner = new VerifiedPartnerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVerifiedPartnerInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVerifiedPartnerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVerifiedPartnerInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVerifiedPartnerInner.innerProperties = VerifiedPartnerProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedVerifiedPartnerInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVerifiedPartnerInner;
        }));
    }
}

