/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.TopicSpaceProvisioningState;
import java.io.IOException;
import java.util.List;

public final class TopicSpaceProperties
implements JsonSerializable<TopicSpaceProperties> {
    private String description;
    private List<String> topicTemplates;
    private TopicSpaceProvisioningState provisioningState;

    public String description() {
        return this.description;
    }

    public TopicSpaceProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> topicTemplates() {
        return this.topicTemplates;
    }

    public TopicSpaceProperties withTopicTemplates(List<String> topicTemplates) {
        this.topicTemplates = topicTemplates;
        return this;
    }

    public TopicSpaceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("topicTemplates", this.topicTemplates, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static TopicSpaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TopicSpaceProperties)jsonReader.readObject(reader -> {
            TopicSpaceProperties deserializedTopicSpaceProperties = new TopicSpaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedTopicSpaceProperties.description = reader.getString();
                    continue;
                }
                if ("topicTemplates".equals(fieldName)) {
                    List topicTemplates;
                    deserializedTopicSpaceProperties.topicTemplates = topicTemplates = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedTopicSpaceProperties.provisioningState = TopicSpaceProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopicSpaceProperties;
        });
    }
}

