/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicSpaceProperties;
import com.azure.resourcemanager.eventgrid.models.TopicSpaceProvisioningState;
import java.io.IOException;
import java.util.List;

public final class TopicSpaceInner
extends ProxyResource {
    private TopicSpaceProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private TopicSpaceProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public TopicSpaceInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicSpaceProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public List<String> topicTemplates() {
        return this.innerProperties() == null ? null : this.innerProperties().topicTemplates();
    }

    public TopicSpaceInner withTopicTemplates(List<String> topicTemplates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicSpaceProperties();
        }
        this.innerProperties().withTopicTemplates(topicTemplates);
        return this;
    }

    public TopicSpaceProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static TopicSpaceInner fromJson(JsonReader jsonReader) throws IOException {
        return (TopicSpaceInner)((Object)jsonReader.readObject(reader -> {
            TopicSpaceInner deserializedTopicSpaceInner = new TopicSpaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTopicSpaceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTopicSpaceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTopicSpaceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTopicSpaceInner.innerProperties = TopicSpaceProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedTopicSpaceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopicSpaceInner;
        }));
    }
}

