/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeliveryConfiguration;
import com.azure.resourcemanager.eventgrid.models.DeliverySchema;
import com.azure.resourcemanager.eventgrid.models.FiltersConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class SubscriptionUpdateParametersProperties
implements JsonSerializable<SubscriptionUpdateParametersProperties> {
    private DeliveryConfiguration deliveryConfiguration;
    private DeliverySchema eventDeliverySchema;
    private FiltersConfiguration filtersConfiguration;
    private OffsetDateTime expirationTimeUtc;
    private Map<String, String> tags;

    public DeliveryConfiguration deliveryConfiguration() {
        return this.deliveryConfiguration;
    }

    public SubscriptionUpdateParametersProperties withDeliveryConfiguration(DeliveryConfiguration deliveryConfiguration) {
        this.deliveryConfiguration = deliveryConfiguration;
        return this;
    }

    public DeliverySchema eventDeliverySchema() {
        return this.eventDeliverySchema;
    }

    public SubscriptionUpdateParametersProperties withEventDeliverySchema(DeliverySchema eventDeliverySchema) {
        this.eventDeliverySchema = eventDeliverySchema;
        return this;
    }

    public FiltersConfiguration filtersConfiguration() {
        return this.filtersConfiguration;
    }

    public SubscriptionUpdateParametersProperties withFiltersConfiguration(FiltersConfiguration filtersConfiguration) {
        this.filtersConfiguration = filtersConfiguration;
        return this;
    }

    public OffsetDateTime expirationTimeUtc() {
        return this.expirationTimeUtc;
    }

    public SubscriptionUpdateParametersProperties withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        this.expirationTimeUtc = expirationTimeUtc;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SubscriptionUpdateParametersProperties withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.deliveryConfiguration() != null) {
            this.deliveryConfiguration().validate();
        }
        if (this.filtersConfiguration() != null) {
            this.filtersConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("deliveryConfiguration", (JsonSerializable)this.deliveryConfiguration);
        jsonWriter.writeStringField("eventDeliverySchema", this.eventDeliverySchema == null ? null : this.eventDeliverySchema.toString());
        jsonWriter.writeJsonField("filtersConfiguration", (JsonSerializable)this.filtersConfiguration);
        jsonWriter.writeStringField("expirationTimeUtc", this.expirationTimeUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeUtc));
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionUpdateParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionUpdateParametersProperties)jsonReader.readObject(reader -> {
            SubscriptionUpdateParametersProperties deserializedSubscriptionUpdateParametersProperties = new SubscriptionUpdateParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deliveryConfiguration".equals(fieldName)) {
                    deserializedSubscriptionUpdateParametersProperties.deliveryConfiguration = DeliveryConfiguration.fromJson(reader);
                    continue;
                }
                if ("eventDeliverySchema".equals(fieldName)) {
                    deserializedSubscriptionUpdateParametersProperties.eventDeliverySchema = DeliverySchema.fromString(reader.getString());
                    continue;
                }
                if ("filtersConfiguration".equals(fieldName)) {
                    deserializedSubscriptionUpdateParametersProperties.filtersConfiguration = FiltersConfiguration.fromJson(reader);
                    continue;
                }
                if ("expirationTimeUtc".equals(fieldName)) {
                    deserializedSubscriptionUpdateParametersProperties.expirationTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSubscriptionUpdateParametersProperties.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionUpdateParametersProperties;
        });
    }
}

