/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeliveryConfiguration;
import com.azure.resourcemanager.eventgrid.models.DeliverySchema;
import com.azure.resourcemanager.eventgrid.models.FiltersConfiguration;
import com.azure.resourcemanager.eventgrid.models.SubscriptionProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class SubscriptionProperties
implements JsonSerializable<SubscriptionProperties> {
    private SubscriptionProvisioningState provisioningState;
    private DeliveryConfiguration deliveryConfiguration;
    private DeliverySchema eventDeliverySchema;
    private FiltersConfiguration filtersConfiguration;
    private OffsetDateTime expirationTimeUtc;
    private Map<String, String> tags;

    public SubscriptionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeliveryConfiguration deliveryConfiguration() {
        return this.deliveryConfiguration;
    }

    public SubscriptionProperties withDeliveryConfiguration(DeliveryConfiguration deliveryConfiguration) {
        this.deliveryConfiguration = deliveryConfiguration;
        return this;
    }

    public DeliverySchema eventDeliverySchema() {
        return this.eventDeliverySchema;
    }

    public SubscriptionProperties withEventDeliverySchema(DeliverySchema eventDeliverySchema) {
        this.eventDeliverySchema = eventDeliverySchema;
        return this;
    }

    public FiltersConfiguration filtersConfiguration() {
        return this.filtersConfiguration;
    }

    public SubscriptionProperties withFiltersConfiguration(FiltersConfiguration filtersConfiguration) {
        this.filtersConfiguration = filtersConfiguration;
        return this;
    }

    public OffsetDateTime expirationTimeUtc() {
        return this.expirationTimeUtc;
    }

    public SubscriptionProperties withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        this.expirationTimeUtc = expirationTimeUtc;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SubscriptionProperties withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.deliveryConfiguration() != null) {
            this.deliveryConfiguration().validate();
        }
        if (this.filtersConfiguration() != null) {
            this.filtersConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("deliveryConfiguration", (JsonSerializable)this.deliveryConfiguration);
        jsonWriter.writeStringField("eventDeliverySchema", this.eventDeliverySchema == null ? null : this.eventDeliverySchema.toString());
        jsonWriter.writeJsonField("filtersConfiguration", (JsonSerializable)this.filtersConfiguration);
        jsonWriter.writeStringField("expirationTimeUtc", this.expirationTimeUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeUtc));
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionProperties)jsonReader.readObject(reader -> {
            SubscriptionProperties deserializedSubscriptionProperties = new SubscriptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedSubscriptionProperties.provisioningState = SubscriptionProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deliveryConfiguration".equals(fieldName)) {
                    deserializedSubscriptionProperties.deliveryConfiguration = DeliveryConfiguration.fromJson(reader);
                    continue;
                }
                if ("eventDeliverySchema".equals(fieldName)) {
                    deserializedSubscriptionProperties.eventDeliverySchema = DeliverySchema.fromString(reader.getString());
                    continue;
                }
                if ("filtersConfiguration".equals(fieldName)) {
                    deserializedSubscriptionProperties.filtersConfiguration = FiltersConfiguration.fromJson(reader);
                    continue;
                }
                if ("expirationTimeUtc".equals(fieldName)) {
                    deserializedSubscriptionProperties.expirationTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSubscriptionProperties.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionProperties;
        });
    }
}

