/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.SubscriptionProperties;
import com.azure.resourcemanager.eventgrid.models.DeliveryConfiguration;
import com.azure.resourcemanager.eventgrid.models.DeliverySchema;
import com.azure.resourcemanager.eventgrid.models.FiltersConfiguration;
import com.azure.resourcemanager.eventgrid.models.SubscriptionProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class SubscriptionInner
extends ProxyResource {
    private SubscriptionProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private SubscriptionProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SubscriptionProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public DeliveryConfiguration deliveryConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryConfiguration();
    }

    public SubscriptionInner withDeliveryConfiguration(DeliveryConfiguration deliveryConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionProperties();
        }
        this.innerProperties().withDeliveryConfiguration(deliveryConfiguration);
        return this;
    }

    public DeliverySchema eventDeliverySchema() {
        return this.innerProperties() == null ? null : this.innerProperties().eventDeliverySchema();
    }

    public SubscriptionInner withEventDeliverySchema(DeliverySchema eventDeliverySchema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionProperties();
        }
        this.innerProperties().withEventDeliverySchema(eventDeliverySchema);
        return this;
    }

    public FiltersConfiguration filtersConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().filtersConfiguration();
    }

    public SubscriptionInner withFiltersConfiguration(FiltersConfiguration filtersConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionProperties();
        }
        this.innerProperties().withFiltersConfiguration(filtersConfiguration);
        return this;
    }

    public OffsetDateTime expirationTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTimeUtc();
    }

    public SubscriptionInner withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionProperties();
        }
        this.innerProperties().withExpirationTimeUtc(expirationTimeUtc);
        return this;
    }

    public Map<String, String> tags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    public SubscriptionInner withTags(Map<String, String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionInner)((Object)jsonReader.readObject(reader -> {
            SubscriptionInner deserializedSubscriptionInner = new SubscriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSubscriptionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSubscriptionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSubscriptionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSubscriptionInner.innerProperties = SubscriptionProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSubscriptionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionInner;
        }));
    }
}

