/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PermissionBindingProperties;
import com.azure.resourcemanager.eventgrid.models.PermissionBindingProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PermissionType;
import java.io.IOException;

public final class PermissionBindingInner
extends ProxyResource {
    private PermissionBindingProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private PermissionBindingProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public PermissionBindingInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PermissionBindingProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String topicSpaceName() {
        return this.innerProperties() == null ? null : this.innerProperties().topicSpaceName();
    }

    public PermissionBindingInner withTopicSpaceName(String topicSpaceName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PermissionBindingProperties();
        }
        this.innerProperties().withTopicSpaceName(topicSpaceName);
        return this;
    }

    public PermissionType permission() {
        return this.innerProperties() == null ? null : this.innerProperties().permission();
    }

    public PermissionBindingInner withPermission(PermissionType permission) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PermissionBindingProperties();
        }
        this.innerProperties().withPermission(permission);
        return this;
    }

    public String clientGroupName() {
        return this.innerProperties() == null ? null : this.innerProperties().clientGroupName();
    }

    public PermissionBindingInner withClientGroupName(String clientGroupName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PermissionBindingProperties();
        }
        this.innerProperties().withClientGroupName(clientGroupName);
        return this;
    }

    public PermissionBindingProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PermissionBindingInner fromJson(JsonReader jsonReader) throws IOException {
        return (PermissionBindingInner)((Object)jsonReader.readObject(reader -> {
            PermissionBindingInner deserializedPermissionBindingInner = new PermissionBindingInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPermissionBindingInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPermissionBindingInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPermissionBindingInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPermissionBindingInner.innerProperties = PermissionBindingProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedPermissionBindingInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPermissionBindingInner;
        }));
    }
}

