/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationActivationState;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;

public final class PartnerDestinationProperties
implements JsonSerializable<PartnerDestinationProperties> {
    private UUID partnerRegistrationImmutableId;
    private String endpointServiceContext;
    private OffsetDateTime expirationTimeIfNotActivatedUtc;
    private PartnerDestinationProvisioningState provisioningState;
    private PartnerDestinationActivationState activationState;
    private String endpointBaseUrl;
    private String messageForActivation;

    public UUID partnerRegistrationImmutableId() {
        return this.partnerRegistrationImmutableId;
    }

    public PartnerDestinationProperties withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.partnerRegistrationImmutableId = partnerRegistrationImmutableId;
        return this;
    }

    public String endpointServiceContext() {
        return this.endpointServiceContext;
    }

    public PartnerDestinationProperties withEndpointServiceContext(String endpointServiceContext) {
        this.endpointServiceContext = endpointServiceContext;
        return this;
    }

    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.expirationTimeIfNotActivatedUtc;
    }

    public PartnerDestinationProperties withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        this.expirationTimeIfNotActivatedUtc = expirationTimeIfNotActivatedUtc;
        return this;
    }

    public PartnerDestinationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PartnerDestinationActivationState activationState() {
        return this.activationState;
    }

    public PartnerDestinationProperties withActivationState(PartnerDestinationActivationState activationState) {
        this.activationState = activationState;
        return this;
    }

    public String endpointBaseUrl() {
        return this.endpointBaseUrl;
    }

    public PartnerDestinationProperties withEndpointBaseUrl(String endpointBaseUrl) {
        this.endpointBaseUrl = endpointBaseUrl;
        return this;
    }

    public String messageForActivation() {
        return this.messageForActivation;
    }

    public PartnerDestinationProperties withMessageForActivation(String messageForActivation) {
        this.messageForActivation = messageForActivation;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerRegistrationImmutableId", Objects.toString(this.partnerRegistrationImmutableId, null));
        jsonWriter.writeStringField("endpointServiceContext", this.endpointServiceContext);
        jsonWriter.writeStringField("expirationTimeIfNotActivatedUtc", this.expirationTimeIfNotActivatedUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeIfNotActivatedUtc));
        jsonWriter.writeStringField("activationState", this.activationState == null ? null : this.activationState.toString());
        jsonWriter.writeStringField("endpointBaseUrl", this.endpointBaseUrl);
        jsonWriter.writeStringField("messageForActivation", this.messageForActivation);
        return jsonWriter.writeEndObject();
    }

    public static PartnerDestinationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerDestinationProperties)jsonReader.readObject(reader -> {
            PartnerDestinationProperties deserializedPartnerDestinationProperties = new PartnerDestinationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("partnerRegistrationImmutableId".equals(fieldName)) {
                    deserializedPartnerDestinationProperties.partnerRegistrationImmutableId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("endpointServiceContext".equals(fieldName)) {
                    deserializedPartnerDestinationProperties.endpointServiceContext = reader.getString();
                    continue;
                }
                if ("expirationTimeIfNotActivatedUtc".equals(fieldName)) {
                    deserializedPartnerDestinationProperties.expirationTimeIfNotActivatedUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPartnerDestinationProperties.provisioningState = PartnerDestinationProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("activationState".equals(fieldName)) {
                    deserializedPartnerDestinationProperties.activationState = PartnerDestinationActivationState.fromString(reader.getString());
                    continue;
                }
                if ("endpointBaseUrl".equals(fieldName)) {
                    deserializedPartnerDestinationProperties.endpointBaseUrl = reader.getString();
                    continue;
                }
                if ("messageForActivation".equals(fieldName)) {
                    deserializedPartnerDestinationProperties.messageForActivation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerDestinationProperties;
        });
    }
}

