/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfigProvisioningState;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfigurationIssues;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfigurationProfile;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterInfo;
import com.azure.resourcemanager.eventgrid.models.ResourceAssociation;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterConfigurationProperties
implements JsonSerializable<NetworkSecurityPerimeterConfigurationProperties> {
    private NetworkSecurityPerimeterConfigProvisioningState provisioningState;
    private List<NetworkSecurityPerimeterConfigurationIssues> provisioningIssues;
    private NetworkSecurityPerimeterInfo networkSecurityPerimeter;
    private ResourceAssociation resourceAssociation;
    private NetworkSecurityPerimeterConfigurationProfile profile;

    public NetworkSecurityPerimeterConfigProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NetworkSecurityPerimeterConfigurationProperties withProvisioningState(NetworkSecurityPerimeterConfigProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public List<NetworkSecurityPerimeterConfigurationIssues> provisioningIssues() {
        return this.provisioningIssues;
    }

    public NetworkSecurityPerimeterConfigurationProperties withProvisioningIssues(List<NetworkSecurityPerimeterConfigurationIssues> provisioningIssues) {
        this.provisioningIssues = provisioningIssues;
        return this;
    }

    public NetworkSecurityPerimeterInfo networkSecurityPerimeter() {
        return this.networkSecurityPerimeter;
    }

    public NetworkSecurityPerimeterConfigurationProperties withNetworkSecurityPerimeter(NetworkSecurityPerimeterInfo networkSecurityPerimeter) {
        this.networkSecurityPerimeter = networkSecurityPerimeter;
        return this;
    }

    public ResourceAssociation resourceAssociation() {
        return this.resourceAssociation;
    }

    public NetworkSecurityPerimeterConfigurationProperties withResourceAssociation(ResourceAssociation resourceAssociation) {
        this.resourceAssociation = resourceAssociation;
        return this;
    }

    public NetworkSecurityPerimeterConfigurationProfile profile() {
        return this.profile;
    }

    public NetworkSecurityPerimeterConfigurationProperties withProfile(NetworkSecurityPerimeterConfigurationProfile profile) {
        this.profile = profile;
        return this;
    }

    public void validate() {
        if (this.provisioningIssues() != null) {
            this.provisioningIssues().forEach(e -> e.validate());
        }
        if (this.networkSecurityPerimeter() != null) {
            this.networkSecurityPerimeter().validate();
        }
        if (this.resourceAssociation() != null) {
            this.resourceAssociation().validate();
        }
        if (this.profile() != null) {
            this.profile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeArrayField("provisioningIssues", this.provisioningIssues, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("networkSecurityPerimeter", (JsonSerializable)this.networkSecurityPerimeter);
        jsonWriter.writeJsonField("resourceAssociation", (JsonSerializable)this.resourceAssociation);
        jsonWriter.writeJsonField("profile", (JsonSerializable)this.profile);
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterConfigurationProperties)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationProperties deserializedNetworkSecurityPerimeterConfigurationProperties = new NetworkSecurityPerimeterConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningState = NetworkSecurityPerimeterConfigProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningIssues".equals(fieldName)) {
                    List provisioningIssues;
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningIssues = provisioningIssues = reader.readArray(reader1 -> NetworkSecurityPerimeterConfigurationIssues.fromJson(reader1));
                    continue;
                }
                if ("networkSecurityPerimeter".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.networkSecurityPerimeter = NetworkSecurityPerimeterInfo.fromJson(reader);
                    continue;
                }
                if ("resourceAssociation".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.resourceAssociation = ResourceAssociation.fromJson(reader);
                    continue;
                }
                if ("profile".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.profile = NetworkSecurityPerimeterConfigurationProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterConfigurationProperties;
        });
    }
}

