/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfigurationIssueSeverity;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfigurationIssueType;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterConfigurationIssuesProperties
implements JsonSerializable<NetworkSecurityPerimeterConfigurationIssuesProperties> {
    private NetworkSecurityPerimeterConfigurationIssueType issueType;
    private NetworkSecurityPerimeterConfigurationIssueSeverity severity;
    private String description;
    private List<String> suggestedResourceIds;
    private List<String> suggestedAccessRules;

    public NetworkSecurityPerimeterConfigurationIssueType issueType() {
        return this.issueType;
    }

    public NetworkSecurityPerimeterConfigurationIssuesProperties withIssueType(NetworkSecurityPerimeterConfigurationIssueType issueType) {
        this.issueType = issueType;
        return this;
    }

    public NetworkSecurityPerimeterConfigurationIssueSeverity severity() {
        return this.severity;
    }

    public NetworkSecurityPerimeterConfigurationIssuesProperties withSeverity(NetworkSecurityPerimeterConfigurationIssueSeverity severity) {
        this.severity = severity;
        return this;
    }

    public String description() {
        return this.description;
    }

    public NetworkSecurityPerimeterConfigurationIssuesProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> suggestedResourceIds() {
        return this.suggestedResourceIds;
    }

    public NetworkSecurityPerimeterConfigurationIssuesProperties withSuggestedResourceIds(List<String> suggestedResourceIds) {
        this.suggestedResourceIds = suggestedResourceIds;
        return this;
    }

    public List<String> suggestedAccessRules() {
        return this.suggestedAccessRules;
    }

    public NetworkSecurityPerimeterConfigurationIssuesProperties withSuggestedAccessRules(List<String> suggestedAccessRules) {
        this.suggestedAccessRules = suggestedAccessRules;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("issueType", this.issueType == null ? null : this.issueType.toString());
        jsonWriter.writeStringField("severity", this.severity == null ? null : this.severity.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("suggestedResourceIds", this.suggestedResourceIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("suggestedAccessRules", this.suggestedAccessRules, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterConfigurationIssuesProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterConfigurationIssuesProperties)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationIssuesProperties deserializedNetworkSecurityPerimeterConfigurationIssuesProperties = new NetworkSecurityPerimeterConfigurationIssuesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("issueType".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationIssuesProperties.issueType = NetworkSecurityPerimeterConfigurationIssueType.fromString(reader.getString());
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationIssuesProperties.severity = NetworkSecurityPerimeterConfigurationIssueSeverity.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationIssuesProperties.description = reader.getString();
                    continue;
                }
                if ("suggestedResourceIds".equals(fieldName)) {
                    List suggestedResourceIds;
                    deserializedNetworkSecurityPerimeterConfigurationIssuesProperties.suggestedResourceIds = suggestedResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("suggestedAccessRules".equals(fieldName)) {
                    List suggestedAccessRules;
                    deserializedNetworkSecurityPerimeterConfigurationIssuesProperties.suggestedAccessRules = suggestedAccessRules = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterConfigurationIssuesProperties;
        });
    }
}

