/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.UpdateTopicSpacesConfigurationInfo;
import com.azure.resourcemanager.eventgrid.models.UpdateTopicsConfigurationInfo;
import java.io.IOException;
import java.util.List;

public final class NamespaceUpdateParameterProperties
implements JsonSerializable<NamespaceUpdateParameterProperties> {
    private UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration;
    private UpdateTopicsConfigurationInfo topicsConfiguration;
    private PublicNetworkAccess publicNetworkAccess;
    private List<InboundIpRule> inboundIpRules;

    public UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration() {
        return this.topicSpacesConfiguration;
    }

    public NamespaceUpdateParameterProperties withTopicSpacesConfiguration(UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration) {
        this.topicSpacesConfiguration = topicSpacesConfiguration;
        return this;
    }

    public UpdateTopicsConfigurationInfo topicsConfiguration() {
        return this.topicsConfiguration;
    }

    public NamespaceUpdateParameterProperties withTopicsConfiguration(UpdateTopicsConfigurationInfo topicsConfiguration) {
        this.topicsConfiguration = topicsConfiguration;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public NamespaceUpdateParameterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    public NamespaceUpdateParameterProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    public void validate() {
        if (this.topicSpacesConfiguration() != null) {
            this.topicSpacesConfiguration().validate();
        }
        if (this.topicsConfiguration() != null) {
            this.topicsConfiguration().validate();
        }
        if (this.inboundIpRules() != null) {
            this.inboundIpRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("topicSpacesConfiguration", (JsonSerializable)this.topicSpacesConfiguration);
        jsonWriter.writeJsonField("topicsConfiguration", (JsonSerializable)this.topicsConfiguration);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("inboundIpRules", this.inboundIpRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NamespaceUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NamespaceUpdateParameterProperties)jsonReader.readObject(reader -> {
            NamespaceUpdateParameterProperties deserializedNamespaceUpdateParameterProperties = new NamespaceUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("topicSpacesConfiguration".equals(fieldName)) {
                    deserializedNamespaceUpdateParameterProperties.topicSpacesConfiguration = UpdateTopicSpacesConfigurationInfo.fromJson(reader);
                    continue;
                }
                if ("topicsConfiguration".equals(fieldName)) {
                    deserializedNamespaceUpdateParameterProperties.topicsConfiguration = UpdateTopicsConfigurationInfo.fromJson(reader);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedNamespaceUpdateParameterProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("inboundIpRules".equals(fieldName)) {
                    List inboundIpRules;
                    deserializedNamespaceUpdateParameterProperties.inboundIpRules = inboundIpRules = reader.readArray(reader1 -> InboundIpRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamespaceUpdateParameterProperties;
        });
    }
}

