/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EventTypeProperties
implements JsonSerializable<EventTypeProperties> {
    private String displayName;
    private String description;
    private String schemaUrl;
    private Boolean isInDefaultSet;

    public String displayName() {
        return this.displayName;
    }

    public EventTypeProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public EventTypeProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String schemaUrl() {
        return this.schemaUrl;
    }

    public EventTypeProperties withSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    public Boolean isInDefaultSet() {
        return this.isInDefaultSet;
    }

    public EventTypeProperties withIsInDefaultSet(Boolean isInDefaultSet) {
        this.isInDefaultSet = isInDefaultSet;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("schemaUrl", this.schemaUrl);
        jsonWriter.writeBooleanField("isInDefaultSet", this.isInDefaultSet);
        return jsonWriter.writeEndObject();
    }

    public static EventTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EventTypeProperties)jsonReader.readObject(reader -> {
            EventTypeProperties deserializedEventTypeProperties = new EventTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedEventTypeProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedEventTypeProperties.description = reader.getString();
                    continue;
                }
                if ("schemaUrl".equals(fieldName)) {
                    deserializedEventTypeProperties.schemaUrl = reader.getString();
                    continue;
                }
                if ("isInDefaultSet".equals(fieldName)) {
                    deserializedEventTypeProperties.isInDefaultSet = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventTypeProperties;
        });
    }
}

