/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.EventTypeProperties;
import java.io.IOException;

public final class EventTypeInner
extends ProxyResource {
    private EventTypeProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private EventTypeProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public EventTypeInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventTypeProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public EventTypeInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventTypeProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String schemaUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().schemaUrl();
    }

    public EventTypeInner withSchemaUrl(String schemaUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventTypeProperties();
        }
        this.innerProperties().withSchemaUrl(schemaUrl);
        return this;
    }

    public Boolean isInDefaultSet() {
        return this.innerProperties() == null ? null : this.innerProperties().isInDefaultSet();
    }

    public EventTypeInner withIsInDefaultSet(Boolean isInDefaultSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventTypeProperties();
        }
        this.innerProperties().withIsInDefaultSet(isInDefaultSet);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static EventTypeInner fromJson(JsonReader jsonReader) throws IOException {
        return (EventTypeInner)((Object)jsonReader.readObject(reader -> {
            EventTypeInner deserializedEventTypeInner = new EventTypeInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEventTypeInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedEventTypeInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEventTypeInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedEventTypeInner.innerProperties = EventTypeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventTypeInner;
        }));
    }
}

