/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.ClientCertificateAuthentication;
import com.azure.resourcemanager.eventgrid.models.ClientProvisioningState;
import com.azure.resourcemanager.eventgrid.models.ClientState;
import java.io.IOException;
import java.util.Map;

public final class ClientProperties
implements JsonSerializable<ClientProperties> {
    private String description;
    private String authenticationName;
    private ClientCertificateAuthentication clientCertificateAuthentication;
    private ClientState state;
    private Map<String, Object> attributes;
    private ClientProvisioningState provisioningState;

    public String description() {
        return this.description;
    }

    public ClientProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String authenticationName() {
        return this.authenticationName;
    }

    public ClientProperties withAuthenticationName(String authenticationName) {
        this.authenticationName = authenticationName;
        return this;
    }

    public ClientCertificateAuthentication clientCertificateAuthentication() {
        return this.clientCertificateAuthentication;
    }

    public ClientProperties withClientCertificateAuthentication(ClientCertificateAuthentication clientCertificateAuthentication) {
        this.clientCertificateAuthentication = clientCertificateAuthentication;
        return this;
    }

    public ClientState state() {
        return this.state;
    }

    public ClientProperties withState(ClientState state) {
        this.state = state;
        return this;
    }

    public Map<String, Object> attributes() {
        return this.attributes;
    }

    public ClientProperties withAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ClientProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.clientCertificateAuthentication() != null) {
            this.clientCertificateAuthentication().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("authenticationName", this.authenticationName);
        jsonWriter.writeJsonField("clientCertificateAuthentication", (JsonSerializable)this.clientCertificateAuthentication);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeMapField("attributes", this.attributes, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static ClientProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClientProperties)jsonReader.readObject(reader -> {
            ClientProperties deserializedClientProperties = new ClientProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedClientProperties.description = reader.getString();
                    continue;
                }
                if ("authenticationName".equals(fieldName)) {
                    deserializedClientProperties.authenticationName = reader.getString();
                    continue;
                }
                if ("clientCertificateAuthentication".equals(fieldName)) {
                    deserializedClientProperties.clientCertificateAuthentication = ClientCertificateAuthentication.fromJson(reader);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedClientProperties.state = ClientState.fromString(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    Map attributes;
                    deserializedClientProperties.attributes = attributes = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClientProperties.provisioningState = ClientProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientProperties;
        });
    }
}

