/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.ChannelProperties;
import com.azure.resourcemanager.eventgrid.models.ChannelProvisioningState;
import com.azure.resourcemanager.eventgrid.models.ChannelType;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicInfo;
import com.azure.resourcemanager.eventgrid.models.ReadinessState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ChannelInner
extends ProxyResource {
    private ChannelProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ChannelProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ChannelType channelType() {
        return this.innerProperties() == null ? null : this.innerProperties().channelType();
    }

    public ChannelInner withChannelType(ChannelType channelType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ChannelProperties();
        }
        this.innerProperties().withChannelType(channelType);
        return this;
    }

    public PartnerTopicInfo partnerTopicInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerTopicInfo();
    }

    public ChannelInner withPartnerTopicInfo(PartnerTopicInfo partnerTopicInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ChannelProperties();
        }
        this.innerProperties().withPartnerTopicInfo(partnerTopicInfo);
        return this;
    }

    public PartnerDestinationInfo partnerDestinationInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerDestinationInfo();
    }

    public ChannelInner withPartnerDestinationInfo(PartnerDestinationInfo partnerDestinationInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ChannelProperties();
        }
        this.innerProperties().withPartnerDestinationInfo(partnerDestinationInfo);
        return this;
    }

    public String messageForActivation() {
        return this.innerProperties() == null ? null : this.innerProperties().messageForActivation();
    }

    public ChannelInner withMessageForActivation(String messageForActivation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ChannelProperties();
        }
        this.innerProperties().withMessageForActivation(messageForActivation);
        return this;
    }

    public ChannelProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ChannelInner withProvisioningState(ChannelProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ChannelProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public ReadinessState readinessState() {
        return this.innerProperties() == null ? null : this.innerProperties().readinessState();
    }

    public ChannelInner withReadinessState(ReadinessState readinessState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ChannelProperties();
        }
        this.innerProperties().withReadinessState(readinessState);
        return this;
    }

    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTimeIfNotActivatedUtc();
    }

    public ChannelInner withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ChannelProperties();
        }
        this.innerProperties().withExpirationTimeIfNotActivatedUtc(expirationTimeIfNotActivatedUtc);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ChannelInner fromJson(JsonReader jsonReader) throws IOException {
        return (ChannelInner)((Object)jsonReader.readObject(reader -> {
            ChannelInner deserializedChannelInner = new ChannelInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedChannelInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedChannelInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedChannelInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedChannelInner.innerProperties = ChannelProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedChannelInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChannelInner;
        }));
    }
}

