/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeMapping;
import java.io.IOException;
import java.util.List;

public final class AzureFunctionEventSubscriptionDestinationProperties
implements JsonSerializable<AzureFunctionEventSubscriptionDestinationProperties> {
    private String resourceId;
    private Integer maxEventsPerBatch;
    private Integer preferredBatchSizeInKilobytes;
    private List<DeliveryAttributeMapping> deliveryAttributeMappings;

    public String resourceId() {
        return this.resourceId;
    }

    public AzureFunctionEventSubscriptionDestinationProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public Integer maxEventsPerBatch() {
        return this.maxEventsPerBatch;
    }

    public AzureFunctionEventSubscriptionDestinationProperties withMaxEventsPerBatch(Integer maxEventsPerBatch) {
        this.maxEventsPerBatch = maxEventsPerBatch;
        return this;
    }

    public Integer preferredBatchSizeInKilobytes() {
        return this.preferredBatchSizeInKilobytes;
    }

    public AzureFunctionEventSubscriptionDestinationProperties withPreferredBatchSizeInKilobytes(Integer preferredBatchSizeInKilobytes) {
        this.preferredBatchSizeInKilobytes = preferredBatchSizeInKilobytes;
        return this;
    }

    public List<DeliveryAttributeMapping> deliveryAttributeMappings() {
        return this.deliveryAttributeMappings;
    }

    public AzureFunctionEventSubscriptionDestinationProperties withDeliveryAttributeMappings(List<DeliveryAttributeMapping> deliveryAttributeMappings) {
        this.deliveryAttributeMappings = deliveryAttributeMappings;
        return this;
    }

    public void validate() {
        if (this.deliveryAttributeMappings() != null) {
            this.deliveryAttributeMappings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeNumberField("maxEventsPerBatch", (Number)this.maxEventsPerBatch);
        jsonWriter.writeNumberField("preferredBatchSizeInKilobytes", (Number)this.preferredBatchSizeInKilobytes);
        jsonWriter.writeArrayField("deliveryAttributeMappings", this.deliveryAttributeMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureFunctionEventSubscriptionDestinationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFunctionEventSubscriptionDestinationProperties)jsonReader.readObject(reader -> {
            AzureFunctionEventSubscriptionDestinationProperties deserializedAzureFunctionEventSubscriptionDestinationProperties = new AzureFunctionEventSubscriptionDestinationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedAzureFunctionEventSubscriptionDestinationProperties.resourceId = reader.getString();
                    continue;
                }
                if ("maxEventsPerBatch".equals(fieldName)) {
                    deserializedAzureFunctionEventSubscriptionDestinationProperties.maxEventsPerBatch = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("preferredBatchSizeInKilobytes".equals(fieldName)) {
                    deserializedAzureFunctionEventSubscriptionDestinationProperties.preferredBatchSizeInKilobytes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("deliveryAttributeMappings".equals(fieldName)) {
                    List deliveryAttributeMappings;
                    deserializedAzureFunctionEventSubscriptionDestinationProperties.deliveryAttributeMappings = deliveryAttributeMappings = reader.readArray(reader1 -> DeliveryAttributeMapping.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFunctionEventSubscriptionDestinationProperties;
        });
    }
}

