/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.SubscriptionUpdateParametersProperties;
import com.azure.resourcemanager.eventgrid.models.DeliveryConfiguration;
import com.azure.resourcemanager.eventgrid.models.DeliverySchema;
import com.azure.resourcemanager.eventgrid.models.FiltersConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SubscriptionUpdateParameters
implements JsonSerializable<SubscriptionUpdateParameters> {
    private SubscriptionUpdateParametersProperties innerProperties;

    private SubscriptionUpdateParametersProperties innerProperties() {
        return this.innerProperties;
    }

    public DeliveryConfiguration deliveryConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryConfiguration();
    }

    public SubscriptionUpdateParameters withDeliveryConfiguration(DeliveryConfiguration deliveryConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionUpdateParametersProperties();
        }
        this.innerProperties().withDeliveryConfiguration(deliveryConfiguration);
        return this;
    }

    public DeliverySchema eventDeliverySchema() {
        return this.innerProperties() == null ? null : this.innerProperties().eventDeliverySchema();
    }

    public SubscriptionUpdateParameters withEventDeliverySchema(DeliverySchema eventDeliverySchema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionUpdateParametersProperties();
        }
        this.innerProperties().withEventDeliverySchema(eventDeliverySchema);
        return this;
    }

    public FiltersConfiguration filtersConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().filtersConfiguration();
    }

    public SubscriptionUpdateParameters withFiltersConfiguration(FiltersConfiguration filtersConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionUpdateParametersProperties();
        }
        this.innerProperties().withFiltersConfiguration(filtersConfiguration);
        return this;
    }

    public OffsetDateTime expirationTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTimeUtc();
    }

    public SubscriptionUpdateParameters withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionUpdateParametersProperties();
        }
        this.innerProperties().withExpirationTimeUtc(expirationTimeUtc);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionUpdateParameters)jsonReader.readObject(reader -> {
            SubscriptionUpdateParameters deserializedSubscriptionUpdateParameters = new SubscriptionUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameters.innerProperties = SubscriptionUpdateParametersProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionUpdateParameters;
        });
    }
}

