/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilterOperatorType;
import java.io.IOException;
import java.util.List;

public final class StringNotEndsWithAdvancedFilter
extends AdvancedFilter {
    private AdvancedFilterOperatorType operatorType = AdvancedFilterOperatorType.STRING_NOT_ENDS_WITH;
    private List<String> values;

    @Override
    public AdvancedFilterOperatorType operatorType() {
        return this.operatorType;
    }

    public List<String> values() {
        return this.values;
    }

    public StringNotEndsWithAdvancedFilter withValues(List<String> values) {
        this.values = values;
        return this;
    }

    @Override
    public StringNotEndsWithAdvancedFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StringNotEndsWithAdvancedFilter fromJson(JsonReader jsonReader) throws IOException {
        return (StringNotEndsWithAdvancedFilter)jsonReader.readObject(reader -> {
            StringNotEndsWithAdvancedFilter deserializedStringNotEndsWithAdvancedFilter = new StringNotEndsWithAdvancedFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedStringNotEndsWithAdvancedFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedStringNotEndsWithAdvancedFilter.operatorType = AdvancedFilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedStringNotEndsWithAdvancedFilter.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStringNotEndsWithAdvancedFilter;
        });
    }
}

