/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import java.io.IOException;

public final class PartnerTopicInfo
implements JsonSerializable<PartnerTopicInfo> {
    private String azureSubscriptionId;
    private String resourceGroupName;
    private String name;
    private EventTypeInfo eventTypeInfo;
    private String source;

    public String azureSubscriptionId() {
        return this.azureSubscriptionId;
    }

    public PartnerTopicInfo withAzureSubscriptionId(String azureSubscriptionId) {
        this.azureSubscriptionId = azureSubscriptionId;
        return this;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public PartnerTopicInfo withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PartnerTopicInfo withName(String name) {
        this.name = name;
        return this;
    }

    public EventTypeInfo eventTypeInfo() {
        return this.eventTypeInfo;
    }

    public PartnerTopicInfo withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        this.eventTypeInfo = eventTypeInfo;
        return this;
    }

    public String source() {
        return this.source;
    }

    public PartnerTopicInfo withSource(String source) {
        this.source = source;
        return this;
    }

    public void validate() {
        if (this.eventTypeInfo() != null) {
            this.eventTypeInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("azureSubscriptionId", this.azureSubscriptionId);
        jsonWriter.writeStringField("resourceGroupName", this.resourceGroupName);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("eventTypeInfo", (JsonSerializable)this.eventTypeInfo);
        jsonWriter.writeStringField("source", this.source);
        return jsonWriter.writeEndObject();
    }

    public static PartnerTopicInfo fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerTopicInfo)jsonReader.readObject(reader -> {
            PartnerTopicInfo deserializedPartnerTopicInfo = new PartnerTopicInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureSubscriptionId".equals(fieldName)) {
                    deserializedPartnerTopicInfo.azureSubscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroupName".equals(fieldName)) {
                    deserializedPartnerTopicInfo.resourceGroupName = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPartnerTopicInfo.name = reader.getString();
                    continue;
                }
                if ("eventTypeInfo".equals(fieldName)) {
                    deserializedPartnerTopicInfo.eventTypeInfo = EventTypeInfo.fromJson(reader);
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedPartnerTopicInfo.source = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerTopicInfo;
        });
    }
}

