/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerNamespaceUpdateParameterProperties;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PartnerNamespaceUpdateParameters
implements JsonSerializable<PartnerNamespaceUpdateParameters> {
    private Map<String, String> tags;
    private PartnerNamespaceUpdateParameterProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public PartnerNamespaceUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private PartnerNamespaceUpdateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public PartnerNamespaceUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerNamespaceUpdateParameterProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundIpRules();
    }

    public PartnerNamespaceUpdateParameters withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerNamespaceUpdateParameterProperties();
        }
        this.innerProperties().withInboundIpRules(inboundIpRules);
        return this;
    }

    public TlsVersion minimumTlsVersionAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersionAllowed();
    }

    public PartnerNamespaceUpdateParameters withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerNamespaceUpdateParameterProperties();
        }
        this.innerProperties().withMinimumTlsVersionAllowed(minimumTlsVersionAllowed);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public PartnerNamespaceUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerNamespaceUpdateParameterProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PartnerNamespaceUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerNamespaceUpdateParameters)jsonReader.readObject(reader -> {
            PartnerNamespaceUpdateParameters deserializedPartnerNamespaceUpdateParameters = new PartnerNamespaceUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedPartnerNamespaceUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPartnerNamespaceUpdateParameters.innerProperties = PartnerNamespaceUpdateParameterProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerNamespaceUpdateParameters;
        });
    }
}

