/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerConfigurationUpdateParameterProperties;
import java.io.IOException;
import java.util.Map;

public final class PartnerConfigurationUpdateParameters
implements JsonSerializable<PartnerConfigurationUpdateParameters> {
    private Map<String, String> tags;
    private PartnerConfigurationUpdateParameterProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public PartnerConfigurationUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private PartnerConfigurationUpdateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    public Integer defaultMaximumExpirationTimeInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultMaximumExpirationTimeInDays();
    }

    public PartnerConfigurationUpdateParameters withDefaultMaximumExpirationTimeInDays(Integer defaultMaximumExpirationTimeInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerConfigurationUpdateParameterProperties();
        }
        this.innerProperties().withDefaultMaximumExpirationTimeInDays(defaultMaximumExpirationTimeInDays);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PartnerConfigurationUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerConfigurationUpdateParameters)jsonReader.readObject(reader -> {
            PartnerConfigurationUpdateParameters deserializedPartnerConfigurationUpdateParameters = new PartnerConfigurationUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedPartnerConfigurationUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPartnerConfigurationUpdateParameters.innerProperties = PartnerConfigurationUpdateParameterProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerConfigurationUpdateParameters;
        });
    }
}

