/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilterOperatorType;
import java.io.IOException;
import java.util.List;

public final class NumberInAdvancedFilter
extends AdvancedFilter {
    private AdvancedFilterOperatorType operatorType = AdvancedFilterOperatorType.NUMBER_IN;
    private List<Double> values;

    @Override
    public AdvancedFilterOperatorType operatorType() {
        return this.operatorType;
    }

    public List<Double> values() {
        return this.values;
    }

    public NumberInAdvancedFilter withValues(List<Double> values) {
        this.values = values;
        return this;
    }

    @Override
    public NumberInAdvancedFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeDouble(element.doubleValue()));
        return jsonWriter.writeEndObject();
    }

    public static NumberInAdvancedFilter fromJson(JsonReader jsonReader) throws IOException {
        return (NumberInAdvancedFilter)jsonReader.readObject(reader -> {
            NumberInAdvancedFilter deserializedNumberInAdvancedFilter = new NumberInAdvancedFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedNumberInAdvancedFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedNumberInAdvancedFilter.operatorType = AdvancedFilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedNumberInAdvancedFilter.values = values = reader.readArray(reader1 -> reader1.getDouble());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNumberInAdvancedFilter;
        });
    }
}

