/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilterOperatorType;
import java.io.IOException;

public final class NumberGreaterThanAdvancedFilter
extends AdvancedFilter {
    private AdvancedFilterOperatorType operatorType = AdvancedFilterOperatorType.NUMBER_GREATER_THAN;
    private Double value;

    @Override
    public AdvancedFilterOperatorType operatorType() {
        return this.operatorType;
    }

    public Double value() {
        return this.value;
    }

    public NumberGreaterThanAdvancedFilter withValue(Double value) {
        this.value = value;
        return this;
    }

    @Override
    public NumberGreaterThanAdvancedFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeNumberField("value", (Number)this.value);
        return jsonWriter.writeEndObject();
    }

    public static NumberGreaterThanAdvancedFilter fromJson(JsonReader jsonReader) throws IOException {
        return (NumberGreaterThanAdvancedFilter)jsonReader.readObject(reader -> {
            NumberGreaterThanAdvancedFilter deserializedNumberGreaterThanAdvancedFilter = new NumberGreaterThanAdvancedFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedNumberGreaterThanAdvancedFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedNumberGreaterThanAdvancedFilter.operatorType = AdvancedFilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedNumberGreaterThanAdvancedFilter.value = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNumberGreaterThanAdvancedFilter;
        });
    }
}

