/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.BoolEqualsFilter;
import com.azure.resourcemanager.eventgrid.models.FilterOperatorType;
import com.azure.resourcemanager.eventgrid.models.IsNotNullFilter;
import com.azure.resourcemanager.eventgrid.models.IsNullOrUndefinedFilter;
import com.azure.resourcemanager.eventgrid.models.NumberGreaterThanFilter;
import com.azure.resourcemanager.eventgrid.models.NumberGreaterThanOrEqualsFilter;
import com.azure.resourcemanager.eventgrid.models.NumberInFilter;
import com.azure.resourcemanager.eventgrid.models.NumberInRangeFilter;
import com.azure.resourcemanager.eventgrid.models.NumberLessThanFilter;
import com.azure.resourcemanager.eventgrid.models.NumberLessThanOrEqualsFilter;
import com.azure.resourcemanager.eventgrid.models.NumberNotInFilter;
import com.azure.resourcemanager.eventgrid.models.NumberNotInRangeFilter;
import com.azure.resourcemanager.eventgrid.models.StringBeginsWithFilter;
import com.azure.resourcemanager.eventgrid.models.StringContainsFilter;
import com.azure.resourcemanager.eventgrid.models.StringEndsWithFilter;
import com.azure.resourcemanager.eventgrid.models.StringInFilter;
import com.azure.resourcemanager.eventgrid.models.StringNotBeginsWithFilter;
import com.azure.resourcemanager.eventgrid.models.StringNotContainsFilter;
import com.azure.resourcemanager.eventgrid.models.StringNotEndsWithFilter;
import com.azure.resourcemanager.eventgrid.models.StringNotInFilter;
import java.io.IOException;

public class Filter
implements JsonSerializable<Filter> {
    private FilterOperatorType operatorType = FilterOperatorType.fromString("Filter");
    private String key;

    public FilterOperatorType operatorType() {
        return this.operatorType;
    }

    public String key() {
        return this.key;
    }

    public Filter withKey(String key) {
        this.key = key;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeStringField("key", this.key);
        return jsonWriter.writeEndObject();
    }

    public static Filter fromJson(JsonReader jsonReader) throws IOException {
        return (Filter)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Filter filter;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("operatorType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("NumberIn".equals(discriminatorValue)) {
                    filter = NumberInFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("NumberNotIn".equals(discriminatorValue)) {
                    filter = NumberNotInFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("NumberLessThan".equals(discriminatorValue)) {
                    filter = NumberLessThanFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("NumberGreaterThan".equals(discriminatorValue)) {
                    filter = NumberGreaterThanFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("NumberLessThanOrEquals".equals(discriminatorValue)) {
                    filter = NumberLessThanOrEqualsFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("NumberGreaterThanOrEquals".equals(discriminatorValue)) {
                    filter = NumberGreaterThanOrEqualsFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("BoolEquals".equals(discriminatorValue)) {
                    filter = BoolEqualsFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("StringIn".equals(discriminatorValue)) {
                    filter = StringInFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("StringNotIn".equals(discriminatorValue)) {
                    filter = StringNotInFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("StringBeginsWith".equals(discriminatorValue)) {
                    filter = StringBeginsWithFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("StringEndsWith".equals(discriminatorValue)) {
                    filter = StringEndsWithFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("StringContains".equals(discriminatorValue)) {
                    filter = StringContainsFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("NumberInRange".equals(discriminatorValue)) {
                    filter = NumberInRangeFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("NumberNotInRange".equals(discriminatorValue)) {
                    filter = NumberNotInRangeFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("StringNotBeginsWith".equals(discriminatorValue)) {
                    filter = StringNotBeginsWithFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("StringNotEndsWith".equals(discriminatorValue)) {
                    filter = StringNotEndsWithFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("StringNotContains".equals(discriminatorValue)) {
                    filter = StringNotContainsFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("IsNullOrUndefined".equals(discriminatorValue)) {
                    filter = IsNullOrUndefinedFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                if ("IsNotNull".equals(discriminatorValue)) {
                    filter = IsNotNullFilter.fromJson(readerToUse.reset());
                    return filter;
                }
                filter = Filter.fromJsonKnownDiscriminator(readerToUse.reset());
                return filter;
            }
        });
    }

    static Filter fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (Filter)jsonReader.readObject(reader -> {
            Filter deserializedFilter = new Filter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operatorType".equals(fieldName)) {
                    deserializedFilter.operatorType = FilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("key".equals(fieldName)) {
                    deserializedFilter.key = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFilter;
        });
    }
}

