/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionInner;
import java.io.IOException;
import java.util.List;

public final class EventSubscriptionsListResult
implements JsonSerializable<EventSubscriptionsListResult> {
    private List<EventSubscriptionInner> value;
    private String nextLink;

    public List<EventSubscriptionInner> value() {
        return this.value;
    }

    public EventSubscriptionsListResult withValue(List<EventSubscriptionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public EventSubscriptionsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static EventSubscriptionsListResult fromJson(JsonReader jsonReader) throws IOException {
        return (EventSubscriptionsListResult)jsonReader.readObject(reader -> {
            EventSubscriptionsListResult deserializedEventSubscriptionsListResult = new EventSubscriptionsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedEventSubscriptionsListResult.value = value = reader.readArray(reader1 -> EventSubscriptionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedEventSubscriptionsListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventSubscriptionsListResult;
        });
    }
}

